/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.AABBAlignedBoundingBox;
import ichttt.mods.firstaid.common.damagesystem.distribution.StandardDamageDistribution;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerSizeHelper {
    private static final Map<EntityEquipmentSlot, AABBAlignedBoundingBox> NORMAL_BOXES;
    private static final Map<EntityEquipmentSlot, AABBAlignedBoundingBox> SNEAKING_BOXES;

    @Nonnull
    public static Map<EntityEquipmentSlot, AABBAlignedBoundingBox> getBoxes(Entity entity) {
        return entity.func_70093_af() ? SNEAKING_BOXES : NORMAL_BOXES;
    }

    public static EntityEquipmentSlot getSlotTypeForProjectileHit(Entity hittingObject, EntityPlayer toTest) {
        float[] inflationSteps;
        Map<EntityEquipmentSlot, AABBAlignedBoundingBox> toUse = PlayerSizeHelper.getBoxes((Entity)toTest);
        Vec3d oldPosition = new Vec3d(hittingObject.field_70165_t, hittingObject.field_70163_u, hittingObject.field_70161_v);
        Vec3d newPosition = new Vec3d(hittingObject.field_70165_t + hittingObject.field_70159_w, hittingObject.field_70163_u + hittingObject.field_70181_x, hittingObject.field_70161_v + hittingObject.field_70179_y);
        for (float inflation : inflationSteps = new float[]{0.01f, 0.1f, 0.2f, 0.3f}) {
            EntityEquipmentSlot bestSlot = null;
            double bestValue = Double.MAX_VALUE;
            for (Map.Entry<EntityEquipmentSlot, AABBAlignedBoundingBox> entry : toUse.entrySet()) {
                double d2;
                double d1;
                AxisAlignedBB axisalignedbb = entry.getValue().createAABB(toTest.func_174813_aQ()).func_186662_g((double)inflation);
                RayTraceResult rtr = axisalignedbb.func_72327_a(oldPosition, newPosition);
                if (rtr == null || !((d1 = oldPosition.func_72436_e(rtr.field_72307_f)) + (d2 = 0.0) < bestValue)) continue;
                bestSlot = entry.getKey();
                bestValue = d1 + d2;
            }
            if (bestSlot == null) continue;
            if (FirstAidConfig.debug) {
                FirstAid.LOGGER.info("getSlotTypeForProjectileHit: Inflation: " + inflation + " best slot: " + bestSlot);
            }
            return bestSlot;
        }
        if (FirstAidConfig.debug) {
            FirstAid.LOGGER.info("getSlotTypeForProjectileHit: Not found!");
        }
        return null;
    }

    public static IDamageDistribution getMeleeDistribution(EntityPlayer player, DamageSource source) {
        Map<EntityEquipmentSlot, AABBAlignedBoundingBox> boxes;
        EntityMob mobEntity;
        Entity causingEntity = source.func_76346_g();
        if (causingEntity != null && causingEntity == source.func_76364_f() && causingEntity instanceof EntityMob && (mobEntity = (EntityMob)causingEntity).func_70638_az() == player && mobEntity.field_70714_bg.field_75782_a.stream().filter(entry -> entry.field_188524_c).anyMatch(prioritizedGoal -> prioritizedGoal.field_75733_a instanceof EntityAIAttackMelee) && !(boxes = PlayerSizeHelper.getBoxes((Entity)player)).isEmpty()) {
            ArrayList<EntityEquipmentSlot> allowedParts = new ArrayList<EntityEquipmentSlot>();
            AxisAlignedBB modAABB = mobEntity.func_174813_aQ().func_72314_b((double)(mobEntity.field_70130_N * 2.0f + player.field_70130_N), 0.0, (double)(mobEntity.field_70130_N * 2.0f + player.field_70130_N));
            for (Map.Entry<EntityEquipmentSlot, AABBAlignedBoundingBox> entry2 : boxes.entrySet()) {
                AxisAlignedBB partAABB = entry2.getValue().createAABB(player.func_174813_aQ());
                if (!modAABB.func_72326_a(partAABB)) continue;
                allowedParts.add(entry2.getKey());
            }
            if (FirstAidConfig.debug) {
                FirstAid.LOGGER.info("getMeleeDistribution: Has distribution with {}", allowedParts);
            }
            if (allowedParts.isEmpty() && player.field_70163_u > mobEntity.field_70163_u && player.field_70163_u - mobEntity.field_70163_u < (double)(mobEntity.field_70130_N * 2.0f)) {
                if (FirstAidConfig.debug) {
                    FirstAid.LOGGER.info("Hack adding feet");
                }
                allowedParts.add(EntityEquipmentSlot.FEET);
            }
            if (!allowedParts.isEmpty() && !allowedParts.containsAll(Arrays.asList(CommonUtils.ARMOR_SLOTS))) {
                ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>> list = new ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>>();
                for (EntityEquipmentSlot allowedPart : allowedParts) {
                    list.add((Pair<EntityEquipmentSlot, EnumPlayerPart[]>)Pair.of((Object)allowedPart, (Object)CommonUtils.getPartArrayForSlot(allowedPart)));
                }
                return new StandardDamageDistribution(list, true, true);
            }
        }
        return null;
    }

    static {
        LinkedHashMap<EntityEquipmentSlot, AABBAlignedBoundingBox> builder = new LinkedHashMap<EntityEquipmentSlot, AABBAlignedBoundingBox>();
        builder.put(EntityEquipmentSlot.FEET, new AABBAlignedBoundingBox(0.0, 0.0, 0.0, 1.0, 0.15, 1.0));
        builder.put(EntityEquipmentSlot.LEGS, new AABBAlignedBoundingBox(0.0, 0.15, 0.0, 1.0, 0.45, 1.0));
        builder.put(EntityEquipmentSlot.CHEST, new AABBAlignedBoundingBox(0.0, 0.45, 0.0, 1.0, 0.8, 1.0));
        builder.put(EntityEquipmentSlot.HEAD, new AABBAlignedBoundingBox(0.0, 0.8, 0.0, 1.0, 1.0, 1.0));
        NORMAL_BOXES = Collections.unmodifiableMap(builder);
        builder = new LinkedHashMap();
        builder.put(EntityEquipmentSlot.FEET, new AABBAlignedBoundingBox(0.0, 0.0, 0.0, 1.0, 0.15, 1.0));
        builder.put(EntityEquipmentSlot.LEGS, new AABBAlignedBoundingBox(0.0, 0.15, 0.0, 1.0, 0.4, 1.0));
        builder.put(EntityEquipmentSlot.CHEST, new AABBAlignedBoundingBox(0.0, 0.4, 0.0, 1.0, 0.75, 1.0));
        builder.put(EntityEquipmentSlot.HEAD, new AABBAlignedBoundingBox(0.0, 0.75, 0.0, 1.0, 1.0, 1.0));
        SNEAKING_BOXES = Collections.unmodifiableMap(builder);
    }
}

