/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.theawesomegem.fishingmadebetter.BetterFishUtil;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.common.item.ItemManager;
import net.theawesomegem.fishingmadebetter.common.item.filletknife.ItemFilletKnife;

public class RecipeFishSliceRaw
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.validInput(inv) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        String fishId;
        Integer[] slots = this.validInput(inv);
        if (slots == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStackFish = inv.func_70301_a(slots[1].intValue());
        if (!BetterFishUtil.isBetterFish(itemStackFish)) {
            return new ItemStack((Item)ItemManager.FISH_SLICE_RAW, 1);
        }
        String fishDisplayName = fishId = BetterFishUtil.getFishId(itemStackFish);
        int fishWeight = BetterFishUtil.getFishWeight(itemStackFish);
        FishData fishData = CustomConfigurationHandler.fishDataMap.get(fishId);
        if (fishData.defaultFillet) {
            return ItemManager.FISH_SLICE_RAW.getItemStack(fishId, fishDisplayName, fishData.filletUseWeight ? Math.min(this.getSliceAmount(fishWeight), 64) : 1);
        }
        Item ret = Item.func_111206_d((String)fishData.filletItem);
        return new ItemStack(ret, fishData.filletUseWeight ? Math.min(this.getSliceAmount(fishWeight), 64) : 1, fishData.filletItemMetadata);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        Integer[] slots = this.validInput(inv);
        ItemStack itemStackKnife = inv.func_70301_a(slots[0].intValue()).func_77946_l();
        ItemStack itemStackFish = inv.func_70301_a(slots[1].intValue());
        Integer remain = 0;
        if (!BetterFishUtil.isBetterFish(itemStackFish)) {
            itemStackKnife.func_77964_b(itemStackKnife.func_77952_i() + 1);
        } else {
            itemStackKnife.func_77964_b(itemStackKnife.func_77952_i() + (CustomConfigurationHandler.fishDataMap.get((Object)BetterFishUtil.getFishId((ItemStack)itemStackFish)).filletUseWeight ? this.getSliceAmount(BetterFishUtil.getFishWeight(itemStackFish)) : 1));
        }
        if (itemStackKnife.func_77952_i() >= itemStackKnife.func_77958_k()) {
            itemStackKnife = ItemStack.field_190927_a;
        }
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (BetterFishUtil.isBetterFish(itemStackFish) && CustomConfigurationHandler.fishDataMap.get((Object)BetterFishUtil.getFishId((ItemStack)itemStackFish)).filletUseWeight) {
            remain = this.getSliceAmount(BetterFishUtil.getFishWeight(itemStackFish)) - 64;
        }
        for (int i = 0; i < ret.size(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemFilletKnife) {
                ret.set(i, (Object)itemStackKnife);
                continue;
            }
            if (!itemStack.func_190926_b() || remain <= 0) continue;
            String fishId = BetterFishUtil.getFishId(itemStackFish);
            FishData fishData = CustomConfigurationHandler.fishDataMap.get(fishId);
            if (remain >= 64) {
                ret.set(i, (Object)(fishData.defaultFillet ? ItemManager.FISH_SLICE_RAW.getItemStack(fishId, fishId, 64) : new ItemStack(Item.func_111206_d((String)fishData.filletItem), 64, fishData.filletItemMetadata)));
            } else {
                ret.set(i, (Object)(fishData.defaultFillet ? ItemManager.FISH_SLICE_RAW.getItemStack(fishId, fishId, remain) : new ItemStack(Item.func_111206_d((String)fishData.filletItem), remain.intValue(), fishData.filletItemMetadata)));
            }
            remain = remain - 64;
        }
        return ret;
    }

    private int getSliceAmount(int weight) {
        return Math.max(1, (int)Math.cbrt(Math.pow(weight, 2.0)));
    }

    @Nullable
    private Integer[] validInput(InventoryCrafting inv) {
        int numStacks = 0;
        int knifeSlot = -1;
        int fishSlot = -1;
        ArrayList<Integer> occupiedSlots = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            ++numStacks;
            occupiedSlots.add(i);
        }
        if (numStacks != 2) {
            return null;
        }
        Iterator i = occupiedSlots.iterator();
        while (i.hasNext()) {
            int i2 = (Integer)i.next();
            ItemStack itemStack = inv.func_70301_a(i2);
            if (itemStack.func_190926_b()) {
                return null;
            }
            if (itemStack.func_77973_b() instanceof ItemFilletKnife && itemStack.func_77958_k() > itemStack.func_77952_i()) {
                knifeSlot = i2;
                continue;
            }
            if (BetterFishUtil.isBetterFish(itemStack) && CustomConfigurationHandler.fishDataMap.get((Object)BetterFishUtil.getFishId((ItemStack)itemStack)).allowFillet) {
                fishSlot = i2;
                continue;
            }
            if (itemStack.func_77973_b().getRegistryName().equals((Object)new ResourceLocation("minecraft:fish"))) {
                fishSlot = i2;
                continue;
            }
            return null;
        }
        Integer[] slots = new Integer[]{knifeSlot, fishSlot};
        return knifeSlot != -1 && fishSlot != -1 ? slots : null;
    }
}

