/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.theawesomegem.fishingmadebetter.BetterFishUtil;
import net.theawesomegem.fishingmadebetter.common.item.fishingrod.ItemBetterFishingRod;

public class RecipeBaitedRod
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.validInput(inv) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        Integer[] slots = this.validInput(inv);
        if (slots == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemFishingRod = inv.func_70301_a(slots[0].intValue()).func_77946_l();
        ItemStack itemBait = inv.func_70301_a(slots[1].intValue()).func_77946_l();
        ItemBetterFishingRod.setBaitItem(itemFishingRod, ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemBait.func_77973_b())).toString());
        ItemBetterFishingRod.setBaitMetadata(itemFishingRod, itemBait.func_77960_j());
        ItemBetterFishingRod.setBaitDisplayName(itemFishingRod, itemBait.func_82833_r());
        return itemFishingRod;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nullable
    private Integer[] validInput(InventoryCrafting inv) {
        int numStacks = 0;
        int rodSlot = -1;
        int baitSlot = -1;
        ArrayList<Integer> occupiedSlots = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            ++numStacks;
            occupiedSlots.add(i);
        }
        if (numStacks != 2) {
            return null;
        }
        Iterator i = occupiedSlots.iterator();
        while (i.hasNext()) {
            int i2 = (Integer)i.next();
            ItemStack itemStack = inv.func_70301_a(i2);
            if (itemStack.func_190926_b()) {
                return null;
            }
            if (itemStack.func_77973_b() instanceof ItemBetterFishingRod) {
                rodSlot = i2;
                continue;
            }
            if (BetterFishUtil.isValidBait(itemStack)) {
                baitSlot = i2;
                continue;
            }
            return null;
        }
        Integer[] slots = new Integer[]{rodSlot, baitSlot};
        return rodSlot != -1 && baitSlot != -1 ? slots : null;
    }
}

