/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.item.fishslice;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.theawesomegem.fishingmadebetter.common.registry.FMBCreativeTab;

public abstract class ItemFishSlice
extends ItemFood {
    public ItemFishSlice(String name, int healAmount, float saturation) {
        super(healAmount, saturation, false);
        this.func_77637_a(FMBCreativeTab.instance);
        this.setRegistryName(name);
        this.func_77655_b("fishingmadebetter." + name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String fishDisplayName = this.getFishDisplayName(stack);
        if (fishDisplayName != null && fishDisplayName.length() > 0) {
            tooltip.add(I18n.func_135052_a((String)"item.fishingmadebetter.fish_slice_raw.tooltip", (Object[])new Object[0]) + " " + fishDisplayName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("fishingmadebetter:fish_slice/" + this.getRegistryName().func_110623_a(), "inventory"));
    }

    public ItemStack getItemStack(String itemId, String displayName, int amount) {
        ItemStack itemStack = new ItemStack((Item)this, amount);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("FishItemId", itemId);
        if (displayName != null) {
            nbt.func_74778_a("FishDisplayName", displayName);
        }
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    @Nullable
    private String getFishDisplayName(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return null;
        }
        if (!itemStack.func_77978_p().func_74764_b("FishDisplayName")) {
            return null;
        }
        return itemStack.func_77978_p().func_74779_i("FishDisplayName");
    }

    @Nullable
    private String getFishItemId(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return null;
        }
        if (!itemStack.func_77978_p().func_74764_b("FishItemId")) {
            return null;
        }
        return itemStack.func_77978_p().func_74779_i("FishItemId");
    }
}

