/*
 * Decompiled with CFR 0.152.
 */
package mcjty.fxcontrol.rules;

import com.google.gson.JsonElement;
import java.util.function.Consumer;
import mcjty.fxcontrol.FxControl;
import mcjty.fxcontrol.compat.ModRuleCompatibilityLayer;
import mcjty.fxcontrol.rules.support.GenericRuleEvaluator;
import mcjty.fxcontrol.rules.support.RuleKeys;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.RuleBase;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.GenericAttributeMapFactory;
import mcjty.tools.typed.Key;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EffectRule
extends RuleBase<RuleBase.EventGetter> {
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    public static final IEventQuery<TickEvent.PlayerTickEvent> EVENT_QUERY = new IEventQuery<TickEvent.PlayerTickEvent>(){

        public World getWorld(TickEvent.PlayerTickEvent o) {
            return o.player.func_130014_f_();
        }

        public BlockPos getPos(TickEvent.PlayerTickEvent o) {
            return o.player.func_180425_c();
        }

        public BlockPos getValidBlockPos(TickEvent.PlayerTickEvent o) {
            return o.player.func_180425_c().func_177977_b();
        }

        public int getY(TickEvent.PlayerTickEvent o) {
            return o.player.func_180425_c().func_177956_o();
        }

        public Entity getEntity(TickEvent.PlayerTickEvent o) {
            return o.player;
        }

        public DamageSource getSource(TickEvent.PlayerTickEvent o) {
            return null;
        }

        public Entity getAttacker(TickEvent.PlayerTickEvent o) {
            return null;
        }

        public EntityPlayer getPlayer(TickEvent.PlayerTickEvent o) {
            return o.player;
        }

        public ItemStack getItem(TickEvent.PlayerTickEvent o) {
            return ItemStack.field_190927_a;
        }
    };
    private final GenericRuleEvaluator ruleEvaluator;
    private final int timeout;

    private EffectRule(AttributeMap map, int time) {
        super(FxControl.setup.getLogger());
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.timeout = time > 0 ? time : 1;
        this.addActions(map, new ModRuleCompatibilityLayer());
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean match(TickEvent.PlayerTickEvent event) {
        return this.ruleEvaluator.match((Event)event, EVENT_QUERY);
    }

    public void action(final TickEvent.PlayerTickEvent event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            public EntityLivingBase getEntityLiving() {
                return event.player;
            }

            public EntityPlayer getPlayer() {
                return event.player;
            }

            public World getWorld() {
                return event.player.func_130014_f_();
            }

            public BlockPos getPosition() {
                return event.player.func_180425_c();
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public static EffectRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        AttributeMap map = null;
        try {
            map = FACTORY.parse(element);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int time = element.getAsJsonObject().has("timeout") ? element.getAsJsonObject().get("timeout").getAsInt() : 20;
        return new EffectRule(map, time);
    }

    static {
        FACTORY.attribute(Attribute.create((Key)RuleKeys.MINTIME)).attribute(Attribute.create((Key)RuleKeys.MAXTIME)).attribute(Attribute.create((Key)RuleKeys.MINLIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXLIGHT)).attribute(Attribute.create((Key)RuleKeys.MINHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MAXHEIGHT)).attribute(Attribute.create((Key)RuleKeys.MINDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.MINSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create((Key)RuleKeys.RANDOM)).attribute(Attribute.create((Key)RuleKeys.SEESKY)).attribute(Attribute.create((Key)RuleKeys.WEATHER)).attribute(Attribute.create((Key)RuleKeys.TEMPCATEGORY)).attribute(Attribute.create((Key)RuleKeys.DIFFICULTY)).attribute(Attribute.create((Key)RuleKeys.STRUCTURE)).attribute(Attribute.create((Key)RuleKeys.GAMESTAGE)).attribute(Attribute.create((Key)RuleKeys.WINTER)).attribute(Attribute.create((Key)RuleKeys.SUMMER)).attribute(Attribute.create((Key)RuleKeys.SPRING)).attribute(Attribute.create((Key)RuleKeys.AUTUMN)).attribute(Attribute.create((Key)RuleKeys.INBUILDING)).attribute(Attribute.create((Key)RuleKeys.INCITY)).attribute(Attribute.create((Key)RuleKeys.INSTREET)).attribute(Attribute.create((Key)RuleKeys.INSPHERE)).attribute(Attribute.createMulti((Key)RuleKeys.AMULET)).attribute(Attribute.createMulti((Key)RuleKeys.RING)).attribute(Attribute.createMulti((Key)RuleKeys.BELT)).attribute(Attribute.createMulti((Key)RuleKeys.TRINKET)).attribute(Attribute.createMulti((Key)RuleKeys.HEAD)).attribute(Attribute.createMulti((Key)RuleKeys.BODY)).attribute(Attribute.createMulti((Key)RuleKeys.CHARM)).attribute(Attribute.createMulti((Key)RuleKeys.BLOCK)).attribute(Attribute.create((Key)RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti((Key)RuleKeys.HELMET)).attribute(Attribute.createMulti((Key)RuleKeys.CHESTPLATE)).attribute(Attribute.createMulti((Key)RuleKeys.LEGGINGS)).attribute(Attribute.createMulti((Key)RuleKeys.BOOTS)).attribute(Attribute.createMulti((Key)RuleKeys.HELDITEM)).attribute(Attribute.createMulti((Key)RuleKeys.PLAYER_HELDITEM)).attribute(Attribute.createMulti((Key)RuleKeys.OFFHANDITEM)).attribute(Attribute.createMulti((Key)RuleKeys.BOTHHANDSITEM)).attribute(Attribute.createMulti((Key)RuleKeys.BIOME)).attribute(Attribute.createMulti((Key)RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti((Key)RuleKeys.DIMENSION)).attribute(Attribute.create((Key)RuleKeys.ACTION_COMMAND)).attribute(Attribute.create((Key)RuleKeys.ACTION_ADDSTAGE)).attribute(Attribute.create((Key)RuleKeys.ACTION_REMOVESTAGE)).attribute(Attribute.create((Key)RuleKeys.ACTION_MESSAGE)).attribute(Attribute.create((Key)RuleKeys.ACTION_FIRE)).attribute(Attribute.create((Key)RuleKeys.ACTION_EXPLOSION)).attribute(Attribute.create((Key)RuleKeys.ACTION_CLEAR)).attribute(Attribute.create((Key)RuleKeys.ACTION_DAMAGE)).attribute(Attribute.create((Key)RuleKeys.ACTION_SETBLOCK)).attribute(Attribute.create((Key)RuleKeys.ACTION_SETHELDITEM)).attribute(Attribute.create((Key)RuleKeys.ACTION_SETHELDAMOUNT)).attribute(Attribute.create((Key)RuleKeys.ACTION_SETSTATE)).attribute(Attribute.create((Key)RuleKeys.ACTION_SETPSTATE)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_POTION)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_GIVE)).attribute(Attribute.createMulti((Key)RuleKeys.ACTION_DROP));
    }
}

