/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationary;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.EntityBiomass;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityParasiticScent
extends Entity {
    private byte scentState;
    private int lifeTicks = 200;
    private int currentL;
    private int dangerToUs;
    private byte active;
    private int delay;
    private int timerTick;
    private byte scentLevel;
    private byte scentReaction;
    private int minwave;
    private int maxwave;
    private int minmob;
    private int maxmob;
    private boolean followTargetScent = false;
    private byte loopLife = (byte)103;
    private byte failing;
    private EntityLivingBase targetScent;

    public EntityParasiticScent(World worldIn) {
        super(worldIn);
    }

    public EntityParasiticScent(World worldIn, int status) {
        this(worldIn);
        this.scentState = (byte)status;
    }

    public EntityParasiticScent(World worldIn, int status, EntityLivingBase tar) {
        this(worldIn, status);
        this.targetScent = tar;
    }

    protected void func_70088_a() {
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public void func_70071_h_() {
        EntityPlayer pa;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.currentL;
        if (this.currentL > this.lifeTicks || this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL || this.loopLife < 0) {
            this.func_70106_y();
            return;
        }
        if (this.targetScent == null) {
            if (this.scentState > 1) {
                this.scentState = 1;
                return;
            }
        } else if (!this.targetScent.func_70089_S() || this.targetScent.func_70068_e((Entity)this) > 4096.0) {
            this.targetScent = null;
            this.scentState = 1;
            return;
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.scentFollower();
        if (this.targetScent instanceof EntityPlayer && ((pa = (EntityPlayer)this.targetScent).func_175149_v() || pa.func_184812_l_())) {
            this.targetScent = null;
            return;
        }
        switch (this.scentState) {
            case 0: {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.scentObserver();
                }
                this.scentListener();
                break;
            }
            case 1: {
                this.scentObserver();
                this.scentListener();
                break;
            }
            case 4: {
                this.scentTactical();
                break;
            }
            case 5: {
                this.scentAttacker();
                break;
            }
            case 6: {
                this.scentBuilder();
                break;
            }
            case 7: {
                this.scentAggressive();
            }
        }
    }

    private void scentListener() {
        if (this.active >= this.scentReaction && this.targetScent != null) {
            this.scentState = (byte)4;
            this.active = (byte)2;
            this.warnPlayers("Scent is active");
            this.lifeTicks = 20 * SRPConfigSystems.scentLifeTactical;
            this.currentL = 0;
            return;
        }
    }

    private void scentObserver() {
        if (this.field_70173_aa % 20 != 0) {
            return;
        }
        if (this.followTargetScent) {
            return;
        }
        if (this.targetScent != null) {
            this.active = (byte)(this.active + 1);
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(64.0);
            List moblist = this.field_70170_p.func_72872_a(EntityParasiteBase.class, axisalignedbb);
            for (EntityParasiteBase mob : moblist) {
                double ra;
                if (!mob.func_70089_S()) continue;
                if (mob.func_70638_az() == null) {
                    ra = mob.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                    if (!(mob.func_70068_e((Entity)this.targetScent) < ra * ra)) continue;
                    mob.func_70624_b(this.targetScent);
                    continue;
                }
                if (mob.func_70638_az().func_70089_S()) continue;
                ra = mob.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                if (!(mob.func_70068_e((Entity)this.targetScent) < ra * ra)) continue;
                mob.func_70624_b(this.targetScent);
            }
            return;
        }
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(64.0);
        List moblist = this.field_70170_p.func_72872_a(EntityParasiteBase.class, axisalignedbb);
        int parasites = moblist.size();
        if (parasites < (moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb)).size()) {
            EntityLivingBase target = null;
            double dis = 40000.0;
            for (EntityLivingBase mob : moblist) {
                EntityPlayer qqq;
                double atm;
                if (mob instanceof EntityParasiteBase || mob instanceof EntityAnimal || mob instanceof EntityWaterMob || mob instanceof EntityCreeper || (atm = mob.func_70068_e((Entity)this)) > 4096.0 || mob instanceof EntityPlayer && ((qqq = (EntityPlayer)mob).func_184812_l_() || qqq.func_175149_v()) || !(atm < dis)) continue;
                dis = atm;
                target = mob;
            }
            this.targetScent = target;
        } else {
            this.currentL += 100;
        }
    }

    private void scentTactical() {
        if (this.active >= SRPConfigSystems.scentSpawnWaves) {
            this.scentState = (byte)5;
            this.active = (byte)(this.active - 5);
            return;
        }
        if (this.targetScent != null) {
            if (this.targetScent.func_70089_S()) {
                this.active = (byte)(this.active + 1);
            } else {
                this.targetScent = null;
            }
        } else if (this.field_70173_aa % 80 == 0) {
            this.active = (byte)(this.active - 1);
            if (this.active <= 0) {
                this.lifeTicks = 20 * SRPConfigSystems.scentLifeObserver;
                this.currentL = 0;
                this.scentState = 1;
                return;
            }
        }
    }

    private void scentAttacker() {
        if (this.checkNearby() <= 6) {
            this.scentState = (byte)6;
        } else {
            this.delay = 100;
            this.lifeTicks += 100;
            this.scentState = (byte)4;
        }
    }

    private void scentBuilder() {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SRPSounds.SCENTWAVE, this.func_184176_by(), 10.0f, 1.0f);
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.targetScent.field_70165_t, this.targetScent.field_70163_u, this.targetScent.field_70161_v, SRPSounds.SCENTWAVE, this.targetScent.func_184176_by(), 10.0f, 1.0f);
        this.loopLife = (byte)(this.loopLife - 1);
        int a = 0;
        int horde = this.maxMinInt(this.minwave, this.maxwave);
        for (int limit = 0; limit < 10; ++limit) {
            a += this.checkNearby();
            if ((a += this.placeWaves(SRPConfigSystems.scentMiniDis, SRPConfigSystems.scentMaxDis)) < horde) continue;
            this.delay = 100 + a * 20;
            this.lifeTicks = 20 * SRPConfigSystems.scentLifeTactical;
            this.currentL = 0;
            this.scentState = (byte)4;
            return;
        }
        this.delay = 200;
        if (SRPConfigSystems.oneMindDebug) {
            System.out.println(" aaa " + a + " h " + horde);
        }
        if (a <= 0) {
            this.delay = 100;
        }
    }

    private void scentAggressive() {
        int enemies = this.maxMinInt(this.minmob, this.maxmob);
        for (int limit2 = 0; limit2 < enemies; ++limit2) {
            this.spawnWaves();
        }
        this.func_70106_y();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scentFollower() {
        if (!this.followTargetScent) return;
        if (this.targetScent == null) {
            this.func_70106_y();
            return;
        }
        if (this.targetScent.func_70089_S()) {
            if (!(this.targetScent.func_70068_e((Entity)this) > 144.0)) return;
            if (!this.targetScent.func_70644_a(SRPPotions.PREY_E)) return;
            this.func_82149_j((Entity)this.targetScent);
            return;
        }
        this.targetScent = null;
        this.followTargetScent = false;
    }

    public boolean getCanFollow() {
        return this.followTargetScent;
    }

    public void setCanFollow(boolean in) {
        this.followTargetScent = in;
    }

    public void setScentState(int in) {
        this.scentState = (byte)in;
    }

    public byte getScentState() {
        return this.scentState;
    }

    public void setScentLife(int in) {
        this.lifeTicks = in;
    }

    public int getScentLife() {
        return this.lifeTicks;
    }

    public void setTargetToKill(EntityLivingBase in) {
        if (this.followTargetScent) {
            return;
        }
        if (!in.func_70089_S()) {
            return;
        }
        this.targetScent = in;
    }

    public EntityLivingBase getTargetToKill() {
        if (this.targetScent == null) {
            return null;
        }
        if (!this.targetScent.func_70089_S()) {
            this.targetScent = null;
            return null;
        }
        return this.targetScent;
    }

    public void increaseDanger(int in, boolean plus) {
        this.dangerToUs = plus ? (this.dangerToUs += in) : in;
        this.updateScentOLevel();
    }

    private void updateScentOLevel() {
        if (this.dangerToUs >= SRPConfigSystems.scentLevelPointsEight) {
            this.scentLevel = (byte)8;
            this.maxmob = SRPConfigSystems.scentWaveMaxMobWaveEight;
            this.minmob = SRPConfigSystems.scentWaveMinMobWaveEight;
            this.maxwave = SRPConfigSystems.scentWaveMaximumEight;
            this.minwave = SRPConfigSystems.scentWaveMinimumEight;
        } else if (this.dangerToUs >= SRPConfigSystems.scentLevelPointsSeven) {
            this.scentLevel = (byte)7;
            this.maxmob = SRPConfigSystems.scentWaveMaxMobWaveSeven;
            this.minmob = SRPConfigSystems.scentWaveMinMobWaveSeven;
            this.maxwave = SRPConfigSystems.scentWaveMaximumSeven;
            this.minwave = SRPConfigSystems.scentWaveMinimumSeven;
        } else if (this.dangerToUs >= SRPConfigSystems.scentLevelPointsSix) {
            this.scentLevel = (byte)6;
            this.maxmob = SRPConfigSystems.scentWaveMaxMobWaveSix;
            this.minmob = SRPConfigSystems.scentWaveMinMobWaveSix;
            this.maxwave = SRPConfigSystems.scentWaveMaximumSix;
            this.minwave = SRPConfigSystems.scentWaveMinimumSix;
        } else if (this.dangerToUs >= SRPConfigSystems.scentLevelPointsFive) {
            this.scentLevel = (byte)5;
            this.maxmob = SRPConfigSystems.scentWaveMaxMobWaveFive;
            this.minmob = SRPConfigSystems.scentWaveMinMobWaveFive;
            this.maxwave = SRPConfigSystems.scentWaveMaximumFive;
            this.minwave = SRPConfigSystems.scentWaveMinimumFive;
        } else if (this.dangerToUs >= SRPConfigSystems.scentLevelPointsFour) {
            this.scentLevel = (byte)4;
            this.maxmob = SRPConfigSystems.scentWaveMaxMobWaveFour;
            this.minmob = SRPConfigSystems.scentWaveMinMobWaveFour;
            this.maxwave = SRPConfigSystems.scentWaveMaximumFour;
            this.minwave = SRPConfigSystems.scentWaveMinimumFour;
        } else if (this.dangerToUs >= SRPConfigSystems.scentLevelPointsThree) {
            this.scentLevel = (byte)3;
            this.maxmob = SRPConfigSystems.scentWaveMaxMobWaveThree;
            this.minmob = SRPConfigSystems.scentWaveMinMobWaveThree;
            this.maxwave = SRPConfigSystems.scentWaveMaximumThree;
            this.minwave = SRPConfigSystems.scentWaveMinimumThree;
        } else if (this.dangerToUs >= SRPConfigSystems.scentLevelPointsTwo) {
            this.scentLevel = (byte)2;
            this.maxmob = SRPConfigSystems.scentWaveMaxMobWaveTwo;
            this.minmob = SRPConfigSystems.scentWaveMinMobWaveTwo;
            this.maxwave = SRPConfigSystems.scentWaveMaximumTwo;
            this.minwave = SRPConfigSystems.scentWaveMinimumTwo;
        } else if (this.dangerToUs >= SRPConfigSystems.scentLevelPointsOne) {
            this.scentLevel = 1;
            this.maxmob = SRPConfigSystems.scentWaveMaxMobWaveOne;
            this.minmob = SRPConfigSystems.scentWaveMinMobWaveOne;
            this.maxwave = SRPConfigSystems.scentWaveMaximumOne;
            this.minwave = SRPConfigSystems.scentWaveMinimumOne;
        } else {
            this.maxmob = SRPConfigSystems.scentWaveMaxMobWaveZero;
            this.minmob = SRPConfigSystems.scentWaveMinMobWaveZero;
            this.maxwave = SRPConfigSystems.scentWaveMaximumZero;
            this.minwave = SRPConfigSystems.scentWaveMinimumZero;
        }
    }

    public int getDanger() {
        return this.dangerToUs;
    }

    public void increaseActivity(int in, boolean plus) {
        if (in > 100) {
            return;
        }
        this.active = plus ? (byte)(this.active + (byte)in) : (byte)in;
    }

    private int checkNearby() {
        int i = 0;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(64.0);
        List moblist = this.field_70170_p.func_72872_a(EntityParasiteBase.class, axisalignedbb);
        for (EntityParasiteBase mob : moblist) {
            if (mob.func_70638_az() != null || !mob.func_70089_S() || this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, this.func_180425_c()) >= 5 || mob instanceof EntityPStationary || mob instanceof EntityBiomass || mob.field_70737_aN > 0 || !this.moveMobToLoc(mob)) continue;
            mob.func_70624_b(this.targetScent);
            ++i;
        }
        if (moblist.size() > 20) {
            return 20;
        }
        return i;
    }

    private boolean moveMobToLoc(EntityParasiteBase in) {
        int minDist = SRPConfigSystems.scentMiniDis;
        int maxDist = SRPConfigSystems.scentMaxDis;
        int loop = 0;
        if (loop < 7) {
            ++loop;
            int range = maxDist * 2;
            int tryX = (int)Math.floor(this.targetScent.field_70165_t - (double)(range / 2) + (double)this.field_70146_Z.nextInt(range));
            int tryY = (int)this.targetScent.field_70163_u;
            int tryZ = (int)Math.floor(this.targetScent.field_70161_v - (double)(range / 2) + (double)this.field_70146_Z.nextInt(range));
            BlockPos poss = new BlockPos(tryX, tryY, tryZ);
            if ((poss = ParasiteEventEntity.getFloor(this.field_70170_p, poss, 10)) == null) {
                return false;
            }
            if (this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, poss) > 4) {
                return false;
            }
            AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)tryX, (double)tryY, (double)tryZ, (double)(tryX + 1), (double)(tryY + 1), (double)(tryZ + 1)).func_72314_b((double)minDist, 5.0, (double)minDist);
            List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase mob : moblist) {
                if (mob instanceof EntityParasiteBase) continue;
                return false;
            }
            if (this.func_70011_f(poss.func_177958_n(), poss.func_177956_o(), poss.func_177952_p()) < (double)minDist || this.func_70011_f(poss.func_177958_n(), poss.func_177956_o(), poss.func_177952_p()) > (double)maxDist) {
                return false;
            }
            in.func_70107_b((double)poss.func_177958_n() + 0.5, poss.func_177956_o(), (double)poss.func_177952_p() + 0.5);
            return true;
        }
        return false;
    }

    public int placeWaves(int minDist, int maxDist) {
        if (this.targetScent == null) {
            return 0;
        }
        int range = maxDist * 2;
        int tryX = (int)Math.floor(this.targetScent.field_70165_t - (double)(range / 2) + (double)this.field_70146_Z.nextInt(range));
        int tryY = (int)this.targetScent.field_70163_u;
        int tryZ = (int)Math.floor(this.targetScent.field_70161_v - (double)(range / 2) + (double)this.field_70146_Z.nextInt(range));
        BlockPos poss = new BlockPos(tryX, tryY, tryZ);
        if ((poss = ParasiteEventEntity.getFloor(this.field_70170_p, poss, 10)) == null) {
            if (SRPConfigSystems.oneMindDebug) {
                System.out.println("wave floor null ");
            }
            return 0;
        }
        if (this.func_70011_f(poss.func_177958_n(), poss.func_177956_o(), poss.func_177952_p()) < (double)minDist || this.func_70011_f(poss.func_177958_n(), poss.func_177956_o(), poss.func_177952_p()) > (double)SRPConfigSystems.oneMinRangeCap) {
            if (SRPConfigSystems.oneMindDebug) {
                System.out.println("distance null " + this.func_70011_f(poss.func_177958_n(), poss.func_177956_o(), poss.func_177952_p()));
            }
            return 0;
        }
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)poss.func_177958_n(), (double)poss.func_177956_o(), (double)poss.func_177952_p(), (double)(poss.func_177958_n() + 1), (double)(poss.func_177956_o() + 1), (double)(poss.func_177952_p() + 1)).func_72314_b((double)maxDist, 16.0, (double)maxDist);
        List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
        int living = moblist.size();
        moblist = this.field_70170_p.func_72872_a(EntityParasiteBase.class, axisalignedbb);
        if (moblist.size() > SRPConfigSystems.scentMobLimit) {
            if (SRPConfigSystems.oneMindDebug) {
                System.out.println("mob limit");
            }
            return -1;
        }
        if (living == moblist.size()) {
            return 0;
        }
        axisalignedbb = new AxisAlignedBB((double)poss.func_177958_n(), (double)poss.func_177956_o(), (double)poss.func_177952_p(), (double)(poss.func_177958_n() + 1), (double)(poss.func_177956_o() + 1), (double)(poss.func_177952_p() + 1)).func_72314_b((double)minDist, 5.0, (double)minDist);
        moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
        for (EntityLivingBase mob : moblist) {
            if (mob instanceof EntityParasiteBase) continue;
            if (SRPConfigSystems.oneMindDebug) {
                System.out.println("too close to nonparasite mob");
            }
            return -1;
        }
        EntityParasiticScent entityliving = new EntityParasiticScent(this.field_70170_p, 7);
        entityliving.increaseDanger(this.dangerToUs, false);
        entityliving.func_70107_b((double)poss.func_177958_n() + 0.5, poss.func_177956_o(), (double)poss.func_177952_p() + 0.5);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, poss) > 4) {
            if (SRPConfigSystems.oneMindDebug) {
                System.out.println("light block");
            }
            return 0;
        }
        this.field_70170_p.func_72838_d((Entity)entityliving);
        entityliving.setTargetToKill(this.targetScent);
        return 1;
    }

    public int spawnWaves() {
        if (this.targetScent == null) {
            return 0;
        }
        String mob = this.getMob();
        EntityLiving entityliving = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(mob), (World)this.field_70170_p);
        if (entityliving == null) {
            return 0;
        }
        entityliving.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entityliving.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
        this.field_70170_p.func_72838_d((Entity)entityliving);
        if (SRPPotions.applySense((EntityLivingBase)entityliving, 200, entityliving.func_70068_e((Entity)this.targetScent), SRPConfigSystems.oneMinRangeCap)) {
            entityliving.func_70624_b(this.targetScent);
            entityliving.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 200, 0, false, false));
        } else {
            entityliving.func_70106_y();
        }
        return 1;
    }

    private byte getareaValue() {
        byte i = this.scentLevel;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(64.0);
        List moblist1 = this.field_70170_p.func_72872_a(EntityParasiticScent.class, axisalignedbb);
        for (EntityParasiticScent mob : moblist1) {
            if (mob.getScentLevel() <= i) continue;
            i = mob.getScentLevel();
        }
        return i;
    }

    private String getMob() {
        String mob = "minecraft:zombie";
        byte area = this.getareaValue();
        switch (area) {
            case 0: {
                mob = SRPConfigSystems.scentLevelZero[this.field_70146_Z.nextInt(SRPConfigSystems.scentLevelZero.length)];
                break;
            }
            case 1: {
                mob = SRPConfigSystems.scentLevelOne[this.field_70146_Z.nextInt(SRPConfigSystems.scentLevelOne.length)];
                break;
            }
            case 2: {
                mob = SRPConfigSystems.scentLevelTwo[this.field_70146_Z.nextInt(SRPConfigSystems.scentLevelTwo.length)];
                break;
            }
            case 3: {
                mob = SRPConfigSystems.scentLevelThree[this.field_70146_Z.nextInt(SRPConfigSystems.scentLevelThree.length)];
                break;
            }
            case 4: {
                mob = SRPConfigSystems.scentLevelFour[this.field_70146_Z.nextInt(SRPConfigSystems.scentLevelFour.length)];
                break;
            }
            case 5: {
                mob = SRPConfigSystems.scentLevelFive[this.field_70146_Z.nextInt(SRPConfigSystems.scentLevelFive.length)];
                break;
            }
            case 6: {
                mob = SRPConfigSystems.scentLevelSix[this.field_70146_Z.nextInt(SRPConfigSystems.scentLevelSix.length)];
                break;
            }
            case 7: {
                mob = SRPConfigSystems.scentLevelSeven[this.field_70146_Z.nextInt(SRPConfigSystems.scentLevelSeven.length)];
                break;
            }
            case 8: {
                mob = SRPConfigSystems.scentLevelEight[this.field_70146_Z.nextInt(SRPConfigSystems.scentLevelEight.length)];
            }
        }
        return mob;
    }

    public void setScentReaction(byte in, boolean override) {
        if (override) {
            this.scentReaction = in;
        } else if (in > this.scentReaction) {
            this.scentReaction = in;
        }
    }

    private byte getScentLevel() {
        return this.scentLevel;
    }

    public void warnPlayers(String in) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(64.0);
        List moblist1 = this.field_70170_p.func_72872_a(EntityPlayer.class, axisalignedbb);
        for (EntityPlayer mob : moblist1) {
            mob.func_146105_b((ITextComponent)new TextComponentString(in), true);
        }
    }

    private int maxMinInt(int min, int max) {
        int atm = max - min + 1;
        return this.field_70146_Z.nextInt(atm) + min;
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!SRPConfigSystems.oneMindDebug) {
            return;
        }
        if (this.field_70173_aa % 20 == 0 && !entityIn.field_70170_p.field_72995_K && entityIn instanceof EntityPlayer && SRPConfigSystems.oneMindDebug) {
            System.out.println("\n id " + this.func_145782_y() + "\n scent state " + this.scentState + "\n active " + this.active + "\n danger " + this.dangerToUs + "\n delay " + this.delay + "\n total life " + this.lifeTicks + "\n current life " + this.currentL + "\n targetScent is null " + (this.targetScent == null) + "\n level " + this.scentLevel + "\n targetScent name " + (this.targetScent != null ? this.targetScent.getClass().toString() : " b ") + "\n min max mob " + this.minmob + " " + this.maxmob + "\n loop " + this.loopLife + "\n fail " + this.failing);
        }
        super.func_70100_b_(entityIn);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("parasitescenttype", 99)) {
            this.scentState = compound.func_74771_c("parasitescenttype");
        }
        if (compound.func_150297_b("parasitescentactive", 99)) {
            this.active = compound.func_74771_c("parasitescentactive");
        }
        if (compound.func_150297_b("parasitescentlevel", 99)) {
            this.scentLevel = compound.func_74771_c("parasitescentlevel");
        }
        if (compound.func_150297_b("parasitelifespan", 99)) {
            this.lifeTicks = compound.func_74762_e("parasitelifespan");
        }
        if (compound.func_150297_b("parasitelifecurrent", 99)) {
            this.currentL = compound.func_74762_e("parasitelifecurrent");
        }
        if (compound.func_150297_b("parasitedangerous", 99)) {
            this.dangerToUs = compound.func_74762_e("parasitedangerous");
        }
        if (compound.func_150297_b("parasitedelay", 99)) {
            this.delay = compound.func_74762_e("parasitedelay");
        }
        if (compound.func_150297_b("parasitescentreaction", 99)) {
            this.scentReaction = compound.func_74771_c("parasitescentreaction");
        }
        if (compound.func_150297_b("parasitescentloopf", 99)) {
            this.loopLife = compound.func_74771_c("parasitescentloopf");
        }
        if (compound.func_150297_b("parasitescentfailing", 99)) {
            this.failing = compound.func_74771_c("parasitescentfailing");
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74774_a("parasitescenttype", this.scentState);
        compound.func_74774_a("parasitescentactive", this.active);
        compound.func_74774_a("parasitescentlevel", this.scentLevel);
        compound.func_74768_a("parasitelifespan", this.lifeTicks);
        compound.func_74768_a("parasitelifecurrent", this.currentL);
        compound.func_74768_a("parasitedangerous", this.dangerToUs);
        compound.func_74768_a("parasitedelay", this.delay);
        compound.func_74774_a("parasitescentreaction", this.scentReaction);
        compound.func_74774_a("parasitescentloopf", this.loopLife);
        compound.func_74774_a("parasitescentfailing", this.failing);
    }
}

