/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.snow.ModConfig;
import snownee.snow.ModSnowBlock;

public class FallingSnowEntity
extends Entity {
    public int fallTime;
    private BlockPos prevPos;
    private int layers;
    protected static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(FallingSnowEntity.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> LAYERS = EntityDataManager.func_187226_a(FallingSnowEntity.class, (DataSerializer)DataSerializers.field_187192_b);

    public FallingSnowEntity(World worldIn) {
        super(worldIn);
        this.prevPos = BlockPos.field_177992_a;
        this.layers = 1;
    }

    public FallingSnowEntity(World worldIn, double x, double y, double z, int layers) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.func_70107_b(x, y + (double)((1.0f - this.field_70131_O) / 2.0f), z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.layers = layers;
        this.setData(new BlockPos((Entity)this), layers);
        this.prevPos = new BlockPos((Entity)this);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        ++this.fallTime;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        BlockPos pos = new BlockPos((Entity)this);
        if (!this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E) {
                if (this.fallTime > 100 && !this.field_70170_p.field_72995_K && (pos.func_177956_o() < 1 || pos.func_177956_o() > 256) || this.fallTime > 600) {
                    this.func_70106_y();
                } else if (!pos.equals((Object)this.prevPos)) {
                    this.prevPos = pos;
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (ModConfig.snowMakingIce && block == Blocks.field_150355_j) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                        this.func_70106_y();
                        return;
                    }
                    if (state.func_185904_a() == Material.field_151587_i) {
                        if (this.field_70170_p.field_72995_K) {
                            Random random = this.field_70170_p.field_73012_v;
                            for (int i = 0; i < 10; ++i) {
                                double d0 = random.nextGaussian() * 0.02;
                                double d1 = random.nextGaussian() * 0.02;
                                double d2 = random.nextGaussian() * 0.02;
                                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + random.nextFloat()), d0, d1, d2, new int[0]);
                            }
                        }
                        this.field_70170_p.func_184133_a(null, pos.func_177984_a(), SoundEvents.field_187656_cX, SoundCategory.AMBIENT, 0.8f, 0.8f);
                        this.func_70106_y();
                        return;
                    }
                    if (state.func_185904_a() == Material.field_151584_j && state.func_185890_d((IBlockAccess)this.field_70170_p, pos) != null) {
                        ModSnowBlock.placeLayersOn(this.field_70170_p, pos.func_177984_a(), this.layers, true, true, 3);
                        this.func_70106_y();
                        return;
                    }
                    if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
                        this.func_70106_y();
                        return;
                    }
                }
            } else {
                IBlockState stateDown = this.field_70170_p.func_180495_p(pos.func_177977_b());
                if (ModSnowBlock.canContainState(stateDown)) {
                    pos = pos.func_177977_b();
                }
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                this.field_70159_w *= (double)0.7f;
                this.field_70179_y *= (double)0.7f;
                this.field_70181_x *= -0.5;
                if (state.func_177230_c() != Blocks.field_180384_M) {
                    ModSnowBlock.placeLayersOn(this.field_70170_p, pos, this.layers, true, true, 3);
                    this.func_70106_y();
                    return;
                }
            }
        }
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(LAYERS, (Object)1);
    }

    public void setData(BlockPos pos, int layers) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
        this.field_70180_af.func_187227_b(LAYERS, (Object)layers);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    @SideOnly(value=Side.CLIENT)
    public int getLayers() {
        return (Integer)this.field_70180_af.func_187225_a(LAYERS);
    }

    @SideOnly(value=Side.CLIENT)
    public World getWorldObj() {
        return this.field_70170_p;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Time", this.fallTime);
        compound.func_74768_a("Layers", this.layers);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.fallTime = compound.func_74762_e("Time");
        if (compound.func_150297_b("Layers", 3)) {
            this.layers = compound.func_74762_e("Layers");
        }
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }
}

