/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.mcft.copy.backpacks.BackpacksContent;
import net.mcft.copy.backpacks.ProxyCommon;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.BackpackRegistry;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.block.entity.TileEntityBackpack;
import net.mcft.copy.backpacks.client.BakedModelDefaultTexture;
import net.mcft.copy.backpacks.client.KeyBindingHandler;
import net.mcft.copy.backpacks.client.RendererBackpack;
import net.mcft.copy.backpacks.misc.util.MiscUtils;
import net.mcft.copy.backpacks.misc.util.NbtUtils;
import net.mcft.copy.backpacks.misc.util.ReflectUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends ProxyCommon {
    public static IBakedModel MODEL_BACKPACK;
    public static IBakedModel MODEL_BACKPACK_TOP;
    public static IBakedModel MODEL_BACKPACK_STRAPS;
    public static IBakedModel MODEL_BACKPACK_ENCH;
    public static IBakedModel MODEL_BACKPACK_ENCH_TOP;
    public static AxisAlignedBB MODEL_BACKPACK_BOX;
    private static final Set<Class<? extends EntityLivingBase>> _hasLayerChecked;
    public static final IItemColor ITEM_COLOR;
    public static final IBlockColor BLOCK_COLOR;
    private static DataParameter<Byte> PLAYER_MODEL_FLAG;
    private boolean _disabledCape = false;

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new KeyBindingHandler());
    }

    @Override
    public void init() {
        super.init();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_184125_al().func_186722_a(BLOCK_COLOR, new Block[]{MiscUtils.getBlockFromItem(BackpacksContent.BACKPACK)});
        mc.getItemColors().func_186730_a(ITEM_COLOR, new Item[]{BackpacksContent.BACKPACK});
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBackpack.class, (TileEntitySpecialRenderer)new RendererBackpack.TileEntity());
        RenderManager manager = mc.func_175598_ae();
        Map skinMap = manager.getSkinMap();
        for (RenderPlayer renderer : skinMap.values()) {
            renderer.func_177094_a((LayerRenderer)new RendererBackpack.Layer((RenderLivingBase<?>)renderer));
        }
    }

    @Override
    public void initBackpackLayers() {
        BackpackRegistry.getDefaultEntityEntries().stream().map(BackpackRegistry.BackpackEntityEntry::getEntityClass).filter(Objects::nonNull).forEach(ProxyClient::ensureHasBackpackLayer);
    }

    public static void ensureHasBackpackLayer(Class<? extends EntityLivingBase> entityClass) {
        if (!_hasLayerChecked.add(entityClass)) {
            return;
        }
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        Render render = manager.func_78715_a(entityClass);
        if (!(render instanceof RenderLivingBase)) {
            return;
        }
        ((RenderLivingBase)render).func_177094_a((LayerRenderer)new RendererBackpack.Layer((RenderLivingBase)render));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        MODEL_BACKPACK = ProxyClient.bakeBlockModel("wearablebackpacks:block/backpack");
        MODEL_BACKPACK_TOP = ProxyClient.bakeBlockModel("wearablebackpacks:block/backpack_top");
        MODEL_BACKPACK_STRAPS = ProxyClient.bakeBlockModel("wearablebackpacks:block/backpack_straps");
        MODEL_BACKPACK_ENCH = new BakedModelDefaultTexture(MODEL_BACKPACK);
        MODEL_BACKPACK_ENCH_TOP = new BakedModelDefaultTexture(MODEL_BACKPACK_TOP);
        MODEL_BACKPACK_BOX = ModelAABBCalculator.calcFrom(MODEL_BACKPACK, MODEL_BACKPACK_TOP);
    }

    private static IBakedModel bakeBlockModel(String location) {
        IModel model = ProxyClient.getModel(new ResourceLocation(location));
        return model.bake(model.getDefaultState(), DefaultVertexFormats.field_176600_a, loc -> Minecraft.func_71410_x().func_147117_R().func_110572_b(loc.toString()));
    }

    private static IModel getModel(ResourceLocation location) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)location);
            if (model == null) {
                WearableBackpacks.LOG.error("Model " + location + " is missing! THIS WILL CAUSE A CRASH!");
            }
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)BackpacksContent.BACKPACK, (int)0, (ModelResourceLocation)new ModelResourceLocation("wearablebackpacks:backpack", "inventory"));
    }

    private static void setWearing(EntityPlayer player, EnumPlayerModelParts part, boolean value) {
        byte current = (Byte)player.func_184212_Q().func_187225_a(PLAYER_MODEL_FLAG);
        current = value ? (byte)(current | part.func_179327_a()) : (byte)(current & ~part.func_179327_a());
        player.func_184212_Q().func_187227_b(PLAYER_MODEL_FLAG, (Object)current);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (BackpackHelper.getBackpack((Entity)player) == null || !player.func_175148_a(EnumPlayerModelParts.CAPE)) {
            return;
        }
        ProxyClient.setWearing(player, EnumPlayerModelParts.CAPE, false);
        this._disabledCape = true;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        if (!this._disabledCape) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ProxyClient.setWearing(player, EnumPlayerModelParts.CAPE, true);
        this._disabledCape = false;
    }

    static {
        _hasLayerChecked = new HashSet<Class<? extends EntityLivingBase>>();
        ITEM_COLOR = (stack, tintIndex) -> NbtUtils.get(stack, Integer.valueOf(10511680), "display", "color");
        BLOCK_COLOR = (state, world, pos, tintIndex) -> {
            IBackpack backpack;
            ItemStack stack = ItemStack.field_190927_a;
            if (world != null && pos != null && (backpack = BackpackHelper.getBackpack(world.func_175625_s(pos))) != null) {
                stack = backpack.getStack();
            }
            return ITEM_COLOR.func_186726_a(stack, tintIndex);
        };
        PLAYER_MODEL_FLAG = (DataParameter)ReflectUtils.get(EntityPlayer.class, "PLAYER_MODEL_FLAG", "field_184827_bp");
    }

    private static class ModelAABBCalculator
    implements IVertexConsumer {
        private double minX = 1.0;
        private double minY = 1.0;
        private double minZ = 1.0;
        private double maxX = 0.0;
        private double maxY = 0.0;
        private double maxZ = 0.0;

        private ModelAABBCalculator() {
        }

        public static AxisAlignedBB calcFrom(IBakedModel ... models) {
            ModelAABBCalculator calc = new ModelAABBCalculator();
            for (IBakedModel model : models) {
                calc.put(model);
            }
            return calc.getAABB();
        }

        public void put(IBakedModel model) {
            for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
                quad.pipe((IVertexConsumer)this);
            }
        }

        public AxisAlignedBB getAABB() {
            return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }

        public VertexFormat getVertexFormat() {
            return DefaultVertexFormats.field_181705_e;
        }

        public void setQuadTint(int tint) {
        }

        public void setQuadOrientation(EnumFacing orientation) {
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
        }

        public void setTexture(TextureAtlasSprite texture) {
        }

        public void put(int element, float ... data) {
            if ((double)data[0] < this.minX) {
                this.minX = data[0];
            }
            if ((double)data[0] > this.maxX) {
                this.maxX = data[0];
            }
            if ((double)data[1] < this.minY) {
                this.minY = data[1];
            }
            if ((double)data[1] > this.maxY) {
                this.maxY = data[1];
            }
            if ((double)data[2] < this.minZ) {
                this.minZ = data[2];
            }
            if ((double)data[2] > this.maxZ) {
                this.maxZ = data[2];
            }
        }
    }
}

