/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.render.entity.ICustomStoneLayer;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerStoneEntity;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerStoneEntityCrack;
import com.github.alexthe666.iceandfire.core.ModKeys;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.FrozenEntityProperties;
import com.github.alexthe666.iceandfire.entity.SirenEntityProperties;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Random;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;

public class EventClient {
    private Random rand = new Random();
    private static final ResourceLocation SIREN_SHADER = new ResourceLocation("iceandfire:shaders/post/siren.json");
    private static final ResourceLocation TEXTURE_0 = new ResourceLocation("textures/blocks/frosted_ice_0.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("textures/blocks/frosted_ice_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("textures/blocks/frosted_ice_2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("textures/blocks/frosted_ice_3.png");

    public static void initializeStoneLayer() {
        for (Map.Entry entry : Minecraft.func_71410_x().func_175598_ae().field_78729_o.entrySet()) {
            Render render = (Render)entry.getValue();
            if (!(render instanceof RenderLivingBase) || !EntityLiving.class.isAssignableFrom((Class)entry.getKey())) continue;
            ((RenderLivingBase)render).func_177094_a((LayerRenderer)new LayerStoneEntity((RenderLivingBase)render));
            ((RenderLivingBase)render).func_177094_a((LayerRenderer)new LayerStoneEntityCrack((RenderLivingBase)render));
        }
        Field renderingRegistryField = ReflectionHelper.findField(RenderingRegistry.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)RenderingRegistry.class.getName(), (String[])new String[]{"INSTANCE", "INSTANCE"}));
        Field entityRendersField = ReflectionHelper.findField(RenderingRegistry.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)RenderingRegistry.class.getName(), (String[])new String[]{"entityRenderers", "entityRenderers"}));
        Field entityRendersOldField = ReflectionHelper.findField(RenderingRegistry.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)RenderingRegistry.class.getName(), (String[])new String[]{"entityRenderersOld", "entityRenderersOld"}));
        RenderingRegistry registry = null;
        try {
            Field modifier = Field.class.getDeclaredField("modifiers");
            modifier.setAccessible(true);
            registry = (RenderingRegistry)renderingRegistryField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (registry != null) {
            LayerStoneEntityCrack crackLayer;
            LayerStoneEntity stoneLayer;
            Render render;
            Map entityRenders = null;
            Map entityRendersOld = null;
            try {
                Field modifier1 = Field.class.getDeclaredField("modifiers");
                modifier1.setAccessible(true);
                entityRenders = (Map)entityRendersField.get(registry);
                entityRendersOld = (Map)entityRendersOldField.get(registry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entityRenders != null) {
                for (Map.Entry entry : entityRenders.entrySet()) {
                    if (entry.getValue() == null) continue;
                    try {
                        render = ((IRenderFactory)entry.getValue()).createRenderFor(Minecraft.func_71410_x().func_175598_ae());
                        if (render == null || !(render instanceof RenderLivingBase) || !EntityLiving.class.isAssignableFrom((Class)entry.getKey())) continue;
                        stoneLayer = render instanceof ICustomStoneLayer ? ((ICustomStoneLayer)render).getStoneLayer((RenderLivingBase)render) : new LayerStoneEntity((RenderLivingBase)render);
                        crackLayer = render instanceof ICustomStoneLayer ? ((ICustomStoneLayer)render).getCrackLayer((RenderLivingBase)render) : new LayerStoneEntityCrack((RenderLivingBase)render);
                        ((RenderLivingBase)render).func_177094_a((LayerRenderer)stoneLayer);
                        ((RenderLivingBase)render).func_177094_a((LayerRenderer)crackLayer);
                    }
                    catch (NullPointerException exp) {
                        System.out.println("Ice and Fire: Could not apply stone render layer to " + ((Class)entry.getKey()).getSimpleName() + ", someone isn't registering their renderer properly... <.<");
                    }
                }
            }
            if (entityRendersOld != null) {
                for (Map.Entry entry : entityRendersOld.entrySet()) {
                    render = (Render)entry.getValue();
                    if (!(render instanceof RenderLivingBase) || !EntityLiving.class.isAssignableFrom((Class)entry.getKey())) continue;
                    stoneLayer = render instanceof ICustomStoneLayer ? ((ICustomStoneLayer)render).getStoneLayer((RenderLivingBase)render) : new LayerStoneEntity((RenderLivingBase)render);
                    crackLayer = render instanceof ICustomStoneLayer ? ((ICustomStoneLayer)render).getCrackLayer((RenderLivingBase)render) : new LayerStoneEntityCrack((RenderLivingBase)render);
                    ((RenderLivingBase)render).func_177094_a((LayerRenderer)stoneLayer);
                    ((RenderLivingBase)render).func_177094_a((LayerRenderer)crackLayer);
                }
            }
        }
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityDragonBase) {
            int currentView = IceAndFire.PROXY.getDragon3rdPersonView();
            float scale = ((EntityDragonBase)player.func_184187_bx()).getRenderSize() / 3.0f;
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && currentView != 0) {
                if (currentView == 1) {
                    GL11.glTranslatef((float)(scale * 0.5f), (float)0.0f, (float)(-scale * 3.0f));
                } else if (currentView == 2) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-scale * 3.0f));
                } else if (currentView == 3) {
                    GL11.glTranslatef((float)(scale * 0.5f), (float)0.0f, (float)(-scale * 0.5f));
                }
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 && currentView != 0) {
                if (currentView == 1) {
                    GL11.glTranslatef((float)(-scale * 1.2f), (float)0.0f, (float)5.0f);
                } else if (currentView == 2) {
                    GL11.glTranslatef((float)(scale * 1.2f), (float)0.0f, (float)5.0f);
                } else if (currentView == 3) {
                    GL11.glTranslatef((float)(scale * -1.5f), (float)0.0f, (float)(scale * 1.5f));
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.field_70170_p.field_72995_K && ModKeys.dragon_change_view.func_151468_f()) {
                int currentView = IceAndFire.PROXY.getDragon3rdPersonView();
                currentView = currentView + 1 > 3 ? 0 : ++currentView;
                IceAndFire.PROXY.setDragon3rdPersonView(currentView);
            }
            SirenEntityProperties sirenProps = (SirenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), SirenEntityProperties.class);
            if (player.field_70170_p.field_72995_K && sirenProps != null) {
                EntityRenderer renderer = Minecraft.func_71410_x().field_71460_t;
                EntitySiren siren = sirenProps.getSiren(event.getEntityLiving().field_70170_p);
                if (siren == null) {
                    sirenProps.isCharmed = false;
                }
                if (sirenProps.isCharmed) {
                    if (this.rand.nextInt(40) == 0) {
                        IceAndFire.PROXY.spawnParticle("siren_appearance", player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 0.0, 0.0);
                    }
                    if (IceAndFire.CONFIG.sirenShader && sirenProps.isCharmed && !renderer.func_147702_a()) {
                        renderer.func_175069_a(SIREN_SHADER);
                    }
                }
                if (IceAndFire.CONFIG.sirenShader && !sirenProps.isCharmed && renderer != null && renderer.func_147706_e() != null && renderer.func_147706_e().func_148022_b() != null && SIREN_SHADER.toString().equals(renderer.func_147706_e().func_148022_b())) {
                    renderer.func_181022_b();
                }
            }
        }
    }

    @SubscribeEvent
    public void onPostRenderLiving(RenderLivingEvent.Post event) {
        FrozenEntityProperties frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntity(), FrozenEntityProperties.class);
        if (frozenProps != null && frozenProps.isFrozen) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179108_z();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            float sideExpand = 0.25f;
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(event.getEntity().func_184177_bl().field_72340_a - event.getEntity().field_70165_t + event.getX() - (double)sideExpand, event.getEntity().func_184177_bl().field_72338_b - event.getEntity().field_70163_u + event.getY(), event.getEntity().func_184177_bl().field_72339_c - event.getEntity().field_70161_v + event.getZ() - (double)sideExpand, event.getEntity().func_184177_bl().field_72336_d - event.getEntity().field_70165_t + event.getX() + (double)sideExpand, event.getEntity().func_184177_bl().field_72337_e - event.getEntity().field_70163_u + event.getY() + (double)sideExpand, event.getEntity().func_184177_bl().field_72334_f - event.getEntity().field_70161_v + event.getZ() + (double)sideExpand);
            event.getRenderer().func_110776_a(EventClient.getIceTexture(frozenProps.ticksUntilUnfrozen));
            EventClient.renderAABB(axisalignedbb1, 0.0, 0.0, 0.0);
            GlStateManager.func_179084_k();
            GlStateManager.func_179133_A();
        }
    }

    private static ResourceLocation getIceTexture(int ticksFrozen) {
        if (ticksFrozen < 100) {
            if (ticksFrozen < 50) {
                if (ticksFrozen < 20) {
                    return TEXTURE_3;
                }
                return TEXTURE_2;
            }
            return TEXTURE_1;
        }
        return TEXTURE_0;
    }

    public static void renderAABB(AxisAlignedBB boundingBox, double x, double y, double z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        double maxX = boundingBox.field_72336_d * 0.625;
        double minX = boundingBox.field_72340_a * 0.625;
        double maxY = boundingBox.field_72337_e * 0.625;
        double minY = boundingBox.field_72338_b * 0.625;
        double maxZ = boundingBox.field_72334_f * 0.625;
        double minZ = boundingBox.field_72339_c * 0.625;
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(minX - maxX, maxY - minY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(maxX - minX, maxY - minY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(maxX - minX, minY - maxY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(minX - maxX, minY - maxY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(minX - maxX, minY - maxY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(maxX - minX, minY - maxY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(maxX - minX, maxY - minY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(minX - maxX, maxY - minY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(minX - maxX, minY - maxY).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(maxX - minX, minY - maxY).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(maxX - minX, maxZ - minZ).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(minX - maxX, maxZ - minZ).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(minX - maxX, minY - maxY).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(maxX - minX, minY - maxY).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(maxX - minX, maxZ - minZ).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(minX - maxX, maxZ - minZ).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(minX - maxX, minY - maxY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(minX - maxX, maxY - minY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(maxX - minX, maxY - minY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(maxX - minX, minY - maxY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(minX - maxX, minY - maxY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(minX - maxX, maxY - minY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(maxX - minX, maxY - minY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(maxX - minX, minY - maxY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }
}

