/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.core.ModVillagers;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.MyrmexAIAttackPlayers;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIFindMate;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIMoveThroughHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIMoveToMate;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWander;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWanderHiveCenter;
import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMyrmexRoyal
extends EntityMyrmexBase {
    private static final ResourceLocation TEXTURE_DESERT = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_royal.png");
    private static final ResourceLocation TEXTURE_JUNGLE = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_royal.png");
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityMyrmexRoyal.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    private int hiveTicks = 0;
    public int releaseTicks = 0;
    private int breedingTicks = 0;
    public int daylightTicks = 0;
    public float flyProgress;
    private boolean isFlying;
    private boolean isLandNavigator;
    private boolean isMating = false;
    public EntityMyrmexRoyal mate;
    public static final ResourceLocation DESERT_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_royal_desert"));
    public static final ResourceLocation JUNGLE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_royal_jungle"));

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    public EntityMyrmexRoyal(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.9f, 1.86f);
        this.switchNavigator(true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new PathNavigateClimber((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new FlyMoveHelper(this);
            this.field_70699_by = new PathNavigateFlying((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("HiveTicks", this.hiveTicks);
        tag.func_74768_a("ReleaseTicks", this.releaseTicks);
        tag.func_74757_a("Flying", this.isFlying());
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.hiveTicks = tag.func_74762_e("HiveTicks");
        this.releaseTicks = tag.func_74762_e("ReleaseTicks");
        this.setFlying(tag.func_74767_n("Flying"));
    }

    public void func_70636_d() {
        double dist;
        boolean flying;
        super.func_70636_d();
        boolean bl = flying = this.isFlying() && !this.field_70122_E;
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 1.0f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (flying) {
            this.field_70181_x += 0.08;
        }
        if (flying && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!flying && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.daylightTicks = this.canSeeSky() ? ++this.daylightTicks : 0;
        if (flying && this.canSeeSky() && this.isBreedingSeason()) {
            ++this.releaseTicks;
        }
        if (!flying && this.canSeeSky() && this.daylightTicks > 300 && this.isBreedingSeason() && this.func_70638_az() == null && this.canMove() && this.field_70122_E && !this.isMating) {
            this.setFlying(true);
            this.field_70181_x += 0.42;
        }
        if (this.getGrowthStage() >= 2) {
            ++this.hiveTicks;
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            dist = this.func_70068_e((Entity)this.func_70638_az());
            if (dist < 6.0) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playStingSound();
            dist = this.func_70068_e((Entity)this.func_70638_az());
            if (dist < 6.0) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2));
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 70, 1));
            }
        }
        if (this.mate != null) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)77);
            if (this.func_70032_d((Entity)this.mate) < 10.0f) {
                this.setFlying(false);
                this.mate.setFlying(false);
                this.isMating = true;
                if (this.field_70122_E && this.mate.field_70122_E) {
                    ++this.breedingTicks;
                    if (this.breedingTicks > 100) {
                        if (this.func_70089_S()) {
                            this.mate.func_70106_y();
                            this.func_70106_y();
                            EntityMyrmexQueen queen = new EntityMyrmexQueen(this.field_70170_p);
                            queen.func_82149_j((Entity)this);
                            queen.setJungleVariant(this.isJungle());
                            queen.setMadeHome(false);
                            if (!this.field_70170_p.field_72995_K) {
                                this.field_70170_p.func_72838_d((Entity)queen);
                            }
                        }
                        this.isMating = false;
                    }
                }
            }
            this.mate.mate = this;
            if (!this.mate.func_70089_S()) {
                this.mate.mate = null;
                this.mate = null;
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MyrmexAITradePlayer(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MyrmexAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MyrmexAIMoveToMate(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIFlyRandom());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new MyrmexAILeaveHive(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new MyrmexAIReEnterHive(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new MyrmexAIMoveThroughHive(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new MyrmexAIWanderHiveCenter(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new MyrmexAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new MyrmexAIDefendHive(this));
        this.field_70715_bh.func_75776_a(2, new MyrmexAIFindMate(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new MyrmexAIAttackPlayers(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, true, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(@Nullable EntityLiving entity) {
                if (entity instanceof EntityMyrmexBase && EntityMyrmexRoyal.this.isBreedingSeason() || entity instanceof EntityMyrmexRoyal) {
                    return false;
                }
                return entity != null && !IMob.field_175450_e.apply((Object)entity) && !EntityMyrmexBase.haveSameHive(EntityMyrmexRoyal.this, (Entity)entity) && DragonUtils.isAlive((EntityLivingBase)entity);
            }
        }));
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this || otherAnimal == null) {
            return false;
        }
        if (otherAnimal.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (otherAnimal instanceof EntityMyrmexBase) {
            if (((EntityMyrmexBase)otherAnimal).getHive() != null && this.getHive() != null) {
                return !this.getHive().equals(((EntityMyrmexBase)otherAnimal).getHive());
            }
            return true;
        }
        return false;
    }

    @Override
    public VillagerRegistry.VillagerProfession getProfessionForge() {
        return this.isJungle() ? ModVillagers.INSTANCE.jungleMyrmexRoyal : ModVillagers.INSTANCE.desertMyrmexRoyal;
    }

    @Override
    public boolean shouldMoveThroughHive() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(9.0);
    }

    @Override
    public ResourceLocation getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 1.25f;
    }

    @Override
    public int getCasteImportance() {
        return 2;
    }

    @Override
    public boolean shouldLeaveHive() {
        return this.isBreedingSeason();
    }

    @Override
    public boolean shouldEnterHive() {
        return !this.isBreedingSeason();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING) {
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_STING : ANIMATION_BITE);
                return true;
            }
        }
        return false;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING};
    }

    public boolean isBreedingSeason() {
        return this.getGrowthStage() >= 2 && this.hiveTicks > 4000 && (this.getHive() == null || this.getHive().reproduces);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 76) {
            this.playEffect(20);
        } else if (id == 77) {
            this.playEffect(7);
        } else {
            super.func_70103_a(id);
        }
    }

    protected void playEffect(int hearts) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        for (int i = 0; i < hearts; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public static BlockPos getPositionRelativetoGround(Entity entity, World world, double x, double z, Random rand) {
        BlockPos pos = new BlockPos(x, entity.field_70163_u, z);
        for (int yDown = 0; yDown < 10; ++yDown) {
            if (world.func_175623_d(pos.func_177979_c(yDown))) continue;
            return pos.func_177981_b(yDown);
        }
        return pos;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.func_70090_H()) {
            this.func_70072_I();
        }
        if (onGroundIn) {
            if (this.field_70143_R > 0.0f) {
                state.func_177230_c().func_180658_a(this.field_70170_p, pos, (Entity)this, this.field_70143_R);
            }
            this.field_70143_R = 0.0f;
        } else if (y < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - y);
        }
    }

    class AIFlyRandom
    extends EntityAIBase {
        BlockPos target;

        public AIFlyRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityMyrmexRoyal.this.isFlying()) {
                this.target = EntityMyrmexRoyal.getPositionRelativetoGround((Entity)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.field_70170_p, EntityMyrmexRoyal.this.field_70165_t + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(30) - 15.0, EntityMyrmexRoyal.this.field_70161_v + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(30) - 15.0, EntityMyrmexRoyal.this.field_70146_Z);
                return this.isDirectPathBetweenPoints(EntityMyrmexRoyal.this.func_180425_c(), this.target) && !EntityMyrmexRoyal.this.func_70605_aq().func_75640_a() && EntityMyrmexRoyal.this.field_70146_Z.nextInt(2) == 0;
            }
            return false;
        }

        protected boolean isDirectPathBetweenPoints(BlockPos posVec31, BlockPos posVec32) {
            RayTraceResult raytraceresult = EntityMyrmexRoyal.this.field_70170_p.func_147447_a(new Vec3d((double)posVec31.func_177958_n() + 0.5, (double)posVec31.func_177956_o() + 0.5, (double)posVec31.func_177952_p() + 0.5), new Vec3d((double)posVec32.func_177958_n() + 0.5, (double)posVec32.func_177956_o() + (double)EntityMyrmexRoyal.this.field_70131_O * 0.5, (double)posVec32.func_177952_p() + 0.5), false, true, false);
            return raytraceresult == null || raytraceresult.field_72313_a == RayTraceResult.Type.MISS;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            if (!this.isDirectPathBetweenPoints(EntityMyrmexRoyal.this.func_180425_c(), this.target)) {
                this.target = EntityMyrmexRoyal.getPositionRelativetoGround((Entity)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.field_70170_p, EntityMyrmexRoyal.this.field_70165_t + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(15) - 7.0, EntityMyrmexRoyal.this.field_70161_v + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(15) - 7.0, EntityMyrmexRoyal.this.field_70146_Z);
            }
            if (EntityMyrmexRoyal.this.field_70170_p.func_175623_d(this.target)) {
                EntityMyrmexRoyal.this.field_70765_h.func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntityMyrmexRoyal.this.func_70638_az() == null) {
                    EntityMyrmexRoyal.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class FlyMoveHelper
    extends EntityMoveHelper {
        public FlyMoveHelper(EntityMyrmexRoyal pixie) {
            super((EntityLiving)pixie);
            this.field_75645_e = 1.75;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityMyrmexRoyal.this.field_70165_t;
                double d1 = this.field_75647_c - EntityMyrmexRoyal.this.field_70163_u;
                double d2 = this.field_75644_d - EntityMyrmexRoyal.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityMyrmexRoyal.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityMyrmexRoyal.this.field_70159_w *= 0.5;
                    EntityMyrmexRoyal.this.field_70181_x *= 0.5;
                    EntityMyrmexRoyal.this.field_70179_y *= 0.5;
                } else {
                    EntityMyrmexRoyal.this.field_70159_w += d0 / d3 * 0.15 * this.field_75645_e;
                    EntityMyrmexRoyal.this.field_70181_x += d1 / d3 * 0.15 * this.field_75645_e;
                    EntityMyrmexRoyal.this.field_70179_y += d2 / d3 * 0.15 * this.field_75645_e;
                    if (EntityMyrmexRoyal.this.func_70638_az() == null) {
                        EntityMyrmexRoyal.this.field_70761_aq = EntityMyrmexRoyal.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityMyrmexRoyal.this.field_70159_w, (double)EntityMyrmexRoyal.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityMyrmexRoyal.this.func_70638_az().field_70165_t - EntityMyrmexRoyal.this.field_70165_t;
                        double d5 = EntityMyrmexRoyal.this.func_70638_az().field_70161_v - EntityMyrmexRoyal.this.field_70161_v;
                        EntityMyrmexRoyal.this.field_70761_aq = EntityMyrmexRoyal.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

