/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.BlockEggInIce;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.IDeadMob;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityEggInIce;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityDragonEgg
extends EntityLiving
implements IBlacklistedFromStatues,
IDeadMob {
    private static final DataParameter<Integer> DRAGON_TYPE = EntityDataManager.func_187226_a(EntityDragonEgg.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DRAGON_AGE = EntityDataManager.func_187226_a(EntityDragonEgg.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityDragonEgg.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityDragonEgg(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.func_70105_a(0.45f, 0.55f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("Color", (int)((byte)this.getType().ordinal()));
        tag.func_74774_a("DragonAge", (byte)this.getDragonAge());
        if (this.getOwnerId() == null) {
            tag.func_74778_a("OwnerUUID", "");
        } else {
            tag.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        String s;
        super.func_70037_a(tag);
        this.setType(EnumDragonEgg.values()[tag.func_74762_e("Color")]);
        this.setDragonAge(tag.func_74771_c("DragonAge"));
        if (tag.func_150297_b("OwnerUUID", 8)) {
            s = tag.func_74779_i("OwnerUUID");
        } else {
            String s1 = tag.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.setOwnerId(UUID.fromString(s));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DRAGON_TYPE, (Object)0);
        this.func_184212_Q().func_187214_a(DRAGON_AGE, (Object)0);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public EnumDragonEgg getType() {
        return EnumDragonEgg.values()[(Integer)this.func_184212_Q().func_187225_a(DRAGON_TYPE)];
    }

    public void setType(EnumDragonEgg newtype) {
        this.func_184212_Q().func_187227_b(DRAGON_TYPE, (Object)newtype.ordinal());
    }

    public boolean func_180431_b(DamageSource i) {
        return i.func_76346_g() != null;
    }

    public int getDragonAge() {
        return (Integer)this.func_184212_Q().func_187225_a(DRAGON_AGE);
    }

    public void setDragonAge(int i) {
        this.func_184212_Q().func_187227_b(DRAGON_AGE, (Object)i);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70050_g(200);
        BlockPos pos = new BlockPos((Entity)this);
        if (this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151581_o && this.getType().isFire) {
            this.setDragonAge(this.getDragonAge() + 1);
        }
        if (this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h && !this.getType().isFire && this.func_70681_au().nextInt(500) == 0) {
            this.func_70106_y();
            this.field_70170_p.func_175656_a(pos, ModBlocks.eggInIce.func_176223_P());
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187561_bM, this.func_184176_by(), 2.5f, 1.0f, false);
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockEggInIce) {
                ((TileEntityEggInIce)this.field_70170_p.func_175625_s((BlockPos)pos)).type = this.getType();
                ((TileEntityEggInIce)this.field_70170_p.func_175625_s((BlockPos)pos)).ownerUUID = this.getOwnerId();
            }
        }
        if (this.getDragonAge() > IceAndFire.CONFIG.dragonEggTime && this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151581_o && this.getType().isFire) {
            this.field_70170_p.func_175698_g(pos);
            EntityFireDragon dragon = new EntityFireDragon(this.field_70170_p);
            dragon.setVariant(this.getType().ordinal());
            dragon.setGender(this.func_70681_au().nextBoolean());
            dragon.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            dragon.setHunger(50);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)dragon);
            }
            dragon.func_70903_f(true);
            dragon.func_184754_b(this.getOwnerId());
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187646_bt, this.func_184176_by(), 2.5f, 1.0f, false);
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, ModSounds.DRAGON_HATCH, this.func_184176_by(), 2.5f, 1.0f, false);
            this.func_70106_y();
        }
    }

    public boolean func_175446_cd() {
        return false;
    }

    public SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return null;
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        if (!(this.field_70170_p.field_72995_K || var1.func_76357_e() || this.field_70128_L)) {
            this.func_145779_a(this.getItem().func_77973_b(), 1);
        }
        this.func_70106_y();
        return super.func_70097_a(var1, var2);
    }

    private ItemStack getItem() {
        switch (this.getType().ordinal()) {
            default: {
                return new ItemStack(ModItems.dragonegg_red);
            }
            case 1: {
                return new ItemStack(ModItems.dragonegg_green);
            }
            case 2: {
                return new ItemStack(ModItems.dragonegg_bronze);
            }
            case 3: {
                return new ItemStack(ModItems.dragonegg_gray);
            }
            case 4: {
                return new ItemStack(ModItems.dragonegg_blue);
            }
            case 5: {
                return new ItemStack(ModItems.dragonegg_white);
            }
            case 6: {
                return new ItemStack(ModItems.dragonegg_sapphire);
            }
            case 7: 
        }
        return new ItemStack(ModItems.dragonegg_silver);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public void onPlayerPlace(EntityPlayer player) {
        this.setOwnerId(player.func_110124_au());
    }

    @Override
    public boolean isMobDead() {
        return true;
    }
}

