/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.connection;

import goblinbob.mobends.core.connection.PlayerSettingsResponse;
import goblinbob.mobends.core.connection.PlayerSettingsTask;
import goblinbob.mobends.core.supporters.SupporterContent;
import goblinbob.mobends.core.util.ConnectionHelper;
import goblinbob.mobends.standard.main.MoBends;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.http.conn.HttpHostConnectException;

public class PlayerSettingsDownloader
implements Runnable {
    private final String apiUrl;
    private final Set<String> loadingPlayersSet = new HashSet<String>();
    private BlockingQueue<PlayerSettingsTask> playerSettingsTasks = new LinkedBlockingQueue<PlayerSettingsTask>();

    public PlayerSettingsDownloader(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                PlayerSettingsTask task = this.playerSettingsTasks.take();
                try {
                    this.performTask(task);
                }
                catch (HttpHostConnectException httpHostConnectException) {
                }
                catch (IOException | URISyntaxException e) {
                    MoBends.LOG.warning("API player settings fetch failed.");
                    e.printStackTrace();
                }
                Set<String> set = this.loadingPlayersSet;
                synchronized (set) {
                    this.loadingPlayersSet.remove(task.playerName);
                }
            }
        }
        catch (InterruptedException e) {
            MoBends.LOG.warning("AssetDownloader has been interrupted");
            return;
        }
    }

    private void performTask(PlayerSettingsTask task) throws IOException, URISyntaxException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", task.playerName);
        PlayerSettingsResponse response = ConnectionHelper.sendGetRequest(new URL(this.apiUrl + "/api/accessory"), params, PlayerSettingsResponse.class);
        SupporterContent.registerPlayerAccessorySettings(task.playerName, response);
        MoBends.LOG.info("Player settings fetch successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchSettingsForPlayer(String playerName) {
        Set<String> set = this.loadingPlayersSet;
        synchronized (set) {
            if (!this.loadingPlayersSet.contains(playerName)) {
                this.playerSettingsTasks.add(new PlayerSettingsTask(playerName));
                this.loadingPlayersSet.add(playerName);
            }
        }
    }
}

