/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import javax.annotation.Nullable;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.SparkPlugin;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.forge.Forge1122CommandSender;
import me.lucko.spark.forge.Forge1122SparkMod;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Forge1122SparkPlugin
implements SparkPlugin,
ICommand {
    private final Forge1122SparkMod mod;
    private final Logger logger;
    protected final ScheduledExecutorService scheduler;
    protected final SparkPlatform platform;
    protected final ThreadDumper.GameThread threadDumper = new ThreadDumper.GameThread();

    protected Forge1122SparkPlugin(Forge1122SparkMod mod) {
        this.mod = mod;
        this.logger = LogManager.getLogger((String)"spark");
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("spark-forge-async-worker");
            thread.setDaemon(true);
            return thread;
        });
        this.platform = new SparkPlatform(this);
    }

    public void enable() {
        this.platform.enable();
    }

    public void disable() {
        this.platform.disable();
        this.scheduler.shutdown();
    }

    public abstract boolean hasPermission(ICommandSender var1, String var2);

    @Override
    public String getVersion() {
        return this.mod.getVersion();
    }

    @Override
    public Path getPluginDirectory() {
        return this.mod.getConfigDirectory();
    }

    @Override
    public void executeAsync(Runnable task) {
        this.scheduler.execute(task);
    }

    @Override
    public void log(Level level, String msg) {
        if (level == Level.INFO) {
            this.logger.info(msg);
        } else if (level == Level.WARNING) {
            this.logger.warn(msg);
        } else if (level == Level.SEVERE) {
            this.logger.error(msg);
        } else {
            throw new IllegalArgumentException(level.getName());
        }
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return this.threadDumper.get();
    }

    public String func_71517_b() {
        return this.getCommandName();
    }

    public String func_71518_a(ICommandSender iCommandSender) {
        return "/" + this.getCommandName();
    }

    public List<String> func_71514_a() {
        return Collections.singletonList(this.getCommandName());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        this.threadDumper.ensureSetup();
        this.platform.executeCommand(new Forge1122CommandSender(sender, this), args);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos blockPos) {
        return this.platform.tabCompleteCommand(new Forge1122CommandSender(sender, this), args);
    }

    public boolean func_184882_a(MinecraftServer minecraftServer, ICommandSender sender) {
        return this.platform.hasPermissionForAnyCommand(new Forge1122CommandSender(sender, this));
    }

    public boolean func_82358_a(String[] strings, int i) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.getCommandName().compareTo(o.func_71517_b());
    }
}

