/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dshuds.hud;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.orecruncher.dshuds.Environment;
import org.orecruncher.dshuds.hud.CompassHUD;
import org.orecruncher.dshuds.hud.GuiOverlay;
import org.orecruncher.dshuds.hud.LightLevelHUD;
import org.orecruncher.dshuds.hud.PotionHUD;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="dshuds")
public final class GuiHUDHandler {
    private static final List<GuiOverlay> overlays = new ArrayList<GuiOverlay>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        for (int i = 0; i < overlays.size(); ++i) {
            overlays.get(i).doRender(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        for (int i = 0; i < overlays.size(); ++i) {
            overlays.get(i).doRender(event);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player != Environment.getPlayer()) {
            return;
        }
        int tickRef = Environment.getTickCounter();
        for (int i = 0; i < overlays.size(); ++i) {
            overlays.get(i).doTick(tickRef);
        }
    }

    static {
        overlays.add(new PotionHUD());
        overlays.add(new CompassHUD());
        overlays.add(new LightLevelHUD());
    }
}

