/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.random;

import ivorius.ivtoolkit.random.BlurrablePivot;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class BlurredValueField
implements NBTCompoundObject,
BlurrablePivot {
    public static final int MAX_VALUES_PER_CHUNK = 10;
    public static final int CHUNKS_SPLIT = 2;
    private List<Value> values = new ArrayList<Value>();
    private int[] chunkCount;
    private BlurredValueField[] chunks;
    private int[] offset;
    private int[] size;
    private int[] center;
    private int[] neighborP1;
    private int[] neighborP2;
    private double weight;
    private double average;

    public BlurredValueField() {
    }

    public BlurredValueField(int ... size) {
        this.setBounds(new int[size.length], size);
    }

    public BlurredValueField(int[] offset, int[] size) {
        this.setBounds(offset, size);
    }

    public static double getValue(Collection<? extends BlurrablePivot> values, int[] position) {
        int idx = 0;
        double total = 0.0;
        double[] invDist = new double[values.size()];
        for (BlurrablePivot blurrablePivot : values) {
            double dist = 0.0;
            for (int j = 0; j < position.length; ++j) {
                double d = position[j] - blurrablePivot.pos()[j];
                dist += d * d;
            }
            dist *= dist;
            if ((dist *= dist) <= 1.0E-4) {
                return blurrablePivot.value();
            }
            invDist[idx] = 1.0 / dist * blurrablePivot.weight();
            total += invDist[idx++];
        }
        double retVal = 0.0;
        total = 1.0 / total;
        idx = 0;
        for (BlurrablePivot blurrablePivot : values) {
            retVal += blurrablePivot.value() * invDist[idx++] * total;
        }
        return retVal;
    }

    public boolean almostContains(int[] pos) {
        for (int d = 0; d < pos.length; ++d) {
            if (pos[d] >= this.neighborP1[d] && pos[d] < this.neighborP2[d]) continue;
            return false;
        }
        return true;
    }

    protected void setBounds(int[] chunkOffset, int[] chunkSize) {
        int d;
        this.offset = chunkOffset;
        this.size = chunkSize;
        this.center = new int[this.offset.length];
        for (d = 0; d < this.offset.length; ++d) {
            this.center[d] = this.offset[d] + this.size[d] / 2;
        }
        this.neighborP1 = new int[this.offset.length];
        this.neighborP2 = new int[this.offset.length];
        for (d = 0; d < this.offset.length; ++d) {
            this.neighborP1[d] = this.offset[d] - this.size[d];
            this.neighborP2[d] = this.offset[d] + this.size[d] * 2;
        }
    }

    public int[] getSize() {
        return (int[])this.size.clone();
    }

    public int[] getOffset() {
        return (int[])this.offset.clone();
    }

    public boolean addValue(Value value) {
        if (value.pos.length != this.size.length) {
            throw new IllegalArgumentException();
        }
        if (this.chunks != null) {
            if (!this.getChunk(value.pos).addValue(value)) {
                return false;
            }
        } else {
            if (this.values.stream().anyMatch(v -> Arrays.equals(((Value)v).pos, value.pos))) {
                return false;
            }
            this.values.add(value);
            if (this.values.size() > 10) {
                this.split();
            }
        }
        this.average = this.calculateAverage();
        this.weight += value.weight();
        return true;
    }

    protected double calculateAverage() {
        if (this.chunks != null) {
            return Arrays.stream(this.chunks).mapToDouble(c -> c.average).sum() / (double)this.chunks.length;
        }
        return this.values.stream().mapToDouble(c -> ((Value)c).value).sum() / (double)this.values.size();
    }

    protected double calculateWeight() {
        if (this.chunks != null) {
            return Arrays.stream(this.chunks).mapToDouble(BlurredValueField::weight).sum();
        }
        return this.values.size();
    }

    protected BlurredValueField getChunk(int[] pos) {
        int[] chunkPos = this.getChunkPos(pos);
        if (!this.hasChunk(chunkPos)) {
            return null;
        }
        return this.chunks[this.chunkToIndex(chunkPos)];
    }

    private boolean hasChunk(int[] chunkPos) {
        for (int d = 0; d < chunkPos.length; ++d) {
            if (chunkPos[d] >= 0 && chunkPos[d] < this.chunkCount[d]) continue;
            return false;
        }
        return true;
    }

    protected int[] getChunkPos(int[] pos) {
        int[] chunkPos = new int[pos.length];
        for (int d = 0; d < pos.length; ++d) {
            chunkPos[d] = (pos[d] - this.offset[d]) * this.chunkCount[d] / this.size[d];
        }
        return chunkPos;
    }

    private int chunkToIndex(int[] chunkPos) {
        int index = 0;
        for (int d = 0; d < chunkPos.length; ++d) {
            index *= this.chunkCount[d];
            index += chunkPos[d];
        }
        return index;
    }

    protected int[] chunkFromIndex(int index) {
        int[] chunkPos = new int[this.size.length];
        for (int i = chunkPos.length - 1; i >= 0; --i) {
            chunkPos[i] = index % this.chunkCount[i];
            index /= this.chunkCount[i];
        }
        return chunkPos;
    }

    protected void split() {
        int max = 1;
        this.chunkCount = new int[this.size.length];
        for (int d = 0; d < this.size.length; ++d) {
            this.chunkCount[d] = Math.min(this.size[d], 2);
            max *= this.chunkCount[d];
        }
        if (max > 1) {
            this.chunks = new BlurredValueField[max];
            for (int c = 0; c < this.chunks.length; ++c) {
                int[] chunkPos = this.chunkFromIndex(c);
                int[] chunkOffset = new int[this.size.length];
                int[] chunkSize = new int[this.size.length];
                for (int d = 0; d < this.size.length; ++d) {
                    chunkOffset[d] = this.calculateChunkOffset(d, chunkPos[d]);
                    int nextOffset = this.calculateChunkOffset(d, chunkPos[d] + 1);
                    chunkSize[d] = nextOffset - chunkOffset[d];
                }
                this.chunks[c] = new BlurredValueField(chunkOffset, chunkSize);
            }
        }
        for (Value value : this.values) {
            this.getChunk(value.pos).addValue(value);
        }
        this.values.clear();
    }

    private int calculateChunkOffset(int d, int chunkPos) {
        int roundUpCorrection = this.chunkCount[d] - 1;
        return this.offset[d] + (this.size[d] * chunkPos + roundUpCorrection) / this.chunkCount[d];
    }

    public boolean addValue(double value, Random random) {
        int[] pos = new int[this.size.length];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = random.nextInt(this.size[i]) + this.offset[i];
        }
        return this.addValue(new Value(value, pos));
    }

    public double getValue(int ... position) {
        ArrayList<BlurrablePivot> relevant = new ArrayList<BlurrablePivot>();
        this.addRelevantValues(position, relevant);
        return BlurredValueField.getValue(relevant, position);
    }

    protected void addRelevantValues(int[] position, List<BlurrablePivot> rv) {
        if (this.chunks != null) {
            for (BlurredValueField chunk : this.chunks) {
                if (chunk.almostContains(position)) {
                    chunk.addRelevantValues(position, rv);
                    continue;
                }
                rv.add(chunk);
            }
        } else {
            rv.addAll(this.values);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.size = compound.func_74759_k("size");
        this.offset = compound.func_74759_k("offset");
        this.values.addAll(NBTCompoundObjects.readListFrom(compound, "values", Value.class));
        if (compound.func_74764_b("chunks")) {
            this.chunks = (BlurredValueField[])NBTCompoundObjects.readListFrom(compound, "chunks", BlurredValueField::new).stream().toArray(BlurredValueField[]::new);
            this.chunkCount = compound.func_74759_k("chunkCount");
        }
        this.weight = this.calculateWeight();
        this.average = this.calculateAverage();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74783_a("size", this.size);
        compound.func_74783_a("offset", this.offset);
        NBTCompoundObjects.writeListTo(compound, "values", this.values);
        if (this.chunks != null) {
            NBTCompoundObjects.writeListTo(compound, "chunks", this.values);
            compound.func_74783_a("chunkCount", this.chunkCount);
        }
    }

    @Override
    public double value() {
        return this.average;
    }

    @Override
    public double weight() {
        return this.weight;
    }

    @Override
    public int[] pos() {
        return this.center;
    }

    public static class Value
    implements NBTCompoundObject,
    BlurrablePivot {
        private double value;
        @Nullable
        private Double weight;
        private int[] pos;

        public Value() {
        }

        public Value(double value, int[] pos) {
            this.value = value;
            this.pos = pos;
        }

        public Value(double value, Double weight, int[] pos) {
            this.value = value;
            this.weight = weight;
            this.pos = pos;
        }

        public double getActiveWeight() {
            return this.weight != null ? this.weight : 1.0;
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            this.value = compound.func_74769_h("value");
            this.weight = compound.func_74764_b("weight") ? Double.valueOf(compound.func_74769_h("weight")) : null;
            this.pos = compound.func_74759_k("pos");
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74780_a("value", this.value);
            if (this.weight != null) {
                compound.func_74780_a("weight", this.weight.doubleValue());
            }
            compound.func_74783_a("pos", this.pos);
        }

        @Override
        public double value() {
            return this.value;
        }

        @Override
        public double weight() {
            return this.weight != null ? this.weight : 1.0;
        }

        @Override
        public int[] pos() {
            return this.pos;
        }
    }
}

