/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class RCAxisAlignedTransform {
    public static BlockPos.MutableBlockPos apply(BlockPos.MutableBlockPos position, int[] size, AxisAlignedTransform2D transform) {
        return RCAxisAlignedTransform.apply((BlockPos)position, position, size, transform);
    }

    public static BlockPos.MutableBlockPos apply(BlockPos position, BlockPos.MutableBlockPos onPosition, int[] size, AxisAlignedTransform2D transform) {
        boolean mirrorX = transform.isMirrorX();
        int rotation = transform.getRotation();
        int positionX = mirrorX ? size[0] - 1 - position.func_177958_n() : position.func_177958_n();
        switch (rotation) {
            case 0: {
                return onPosition.func_181079_c(positionX, position.func_177956_o(), position.func_177952_p());
            }
            case 1: {
                return onPosition.func_181079_c(size[2] - 1 - position.func_177952_p(), position.func_177956_o(), positionX);
            }
            case 2: {
                return onPosition.func_181079_c(size[0] - 1 - positionX, position.func_177956_o(), size[2] - 1 - position.func_177952_p());
            }
            case 3: {
                return onPosition.func_181079_c(position.func_177952_p(), position.func_177956_o(), size[0] - 1 - positionX);
            }
        }
        throw new InternalError();
    }

    public static BlockArea apply(AxisAlignedTransform2D transform, BlockArea area, int[] size, int centerCorrection) {
        return RCAxisAlignedTransform.apply(transform, area, new BlockArea(BlockPos.field_177992_a, BlockPos.field_177992_a), size, centerCorrection);
    }

    public static BlockArea apply(AxisAlignedTransform2D transform, BlockArea area, BlockArea on, int[] size, int centerCorrection) {
        on.setPoint1(transform.apply(area.getPoint1(), size, centerCorrection));
        on.setPoint2(transform.apply(area.getPoint2(), size, centerCorrection));
        return on;
    }

    public static AxisAlignedTransform2D invert(AxisAlignedTransform2D transform2D) {
        return AxisAlignedTransform2D.from((int)(transform2D.isMirrorX() ? transform2D.getRotation() : -transform2D.getRotation()), (boolean)transform2D.isMirrorX());
    }

    public static int[] applySize(AxisAlignedTransform2D transform, int[] size) {
        if (transform.getRotation() % 2 == 1) {
            size = (int[])size.clone();
            int cache = size[0];
            size[0] = size[2];
            size[2] = cache;
            return size;
        }
        return size;
    }

    public static AxisAlignedTransform2D read(NBTTagCompound compound, String rotation, String mirrorX) {
        return AxisAlignedTransform2D.from((int)compound.func_74762_e(rotation), (boolean)compound.func_74767_n(mirrorX));
    }

    public static void write(NBTTagCompound compound, AxisAlignedTransform2D transform, String rotation, String mirrorX) {
        compound.func_74768_a(rotation, transform.getRotation());
        compound.func_74757_a(mirrorX, transform.isMirrorX());
    }
}

