/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex;

import com.google.common.base.Strings;
import ivorius.ivtoolkit.tools.IvFMLIntercommHandler;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.dimensions.DimensionDictionary;
import ivorius.reccomplex.files.loading.FileLoadContext;
import ivorius.reccomplex.files.loading.LeveledRegistry;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Logger;

public class RCCommunicationHandler
extends IvFMLIntercommHandler {
    public RCCommunicationHandler(Logger logger, String modOwnerID, Object modInstance) {
        super(logger, modOwnerID, modInstance);
    }

    protected boolean handleMessage(FMLInterModComms.IMCMessage message, boolean server, boolean runtime) {
        if (this.isMessage("loadFile", message, NBTTagCompound.class) || this.isMessage("loadInventoryGenerator", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String genPath = cmp.func_74779_i("genPath");
            String genID = cmp.func_150297_b("genID", 8) ? cmp.func_74779_i("genID") : null;
            boolean generates = cmp.func_74767_n("generates");
            ResourceLocation resourceLocation = new ResourceLocation(genPath);
            RecurrentComplex.loader.tryLoad(resourceLocation, genID, new FileLoadContext(resourceLocation.func_110624_b(), generates, LeveledRegistry.Level.INTERNAL));
            return true;
        }
        if (this.isMessage("registerDimension", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            int dimensionID = cmp.func_74762_e("dimensionID");
            String[] types = IvNBTHelper.readNBTStrings((String)"types", (NBTTagCompound)cmp);
            if (types != null) {
                DimensionDictionary.registerDimensionTypes(dimensionID, Arrays.asList(types));
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'types' key!");
            }
            return true;
        }
        if (this.isMessage("unregisterDimension", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            int dimensionID = cmp.func_74762_e("dimensionID");
            String[] types = IvNBTHelper.readNBTStrings((String)"types", (NBTTagCompound)cmp);
            if (types != null) {
                DimensionDictionary.unregisterDimensionTypes(dimensionID, Arrays.asList(types));
            } else {
                DimensionDictionary.unregisterDimensionTypes(dimensionID, null);
            }
            return true;
        }
        if (this.isMessage("registerDimensionType", message, String.class)) {
            DimensionDictionary.registerType(message.getStringValue());
            return true;
        }
        if (this.isMessage("registerDimensionSubtypes", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String type = cmp.func_74779_i("type");
            String[] subtypes = IvNBTHelper.readNBTStrings((String)"subtypes", (NBTTagCompound)cmp);
            if (!Strings.isNullOrEmpty((String)type)) {
                DimensionDictionary.registerSubtypes(type, Arrays.asList(subtypes));
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'subtypes' key!");
            }
            return true;
        }
        if (this.isMessage("registerDimensionSupertypes", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            String type = cmp.func_74779_i("type");
            String[] subtypes = IvNBTHelper.readNBTStrings((String)"supertypes", (NBTTagCompound)cmp);
            if (!Strings.isNullOrEmpty((String)type)) {
                DimensionDictionary.registerSupertypes(type, Arrays.asList(subtypes));
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - missing 'supertypes' key!");
            }
            return true;
        }
        if (this.isMessage("registerLegacyBlockIds", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            Block block = RecurrentComplex.specialRegistry.blockFromID(new ResourceLocation(cmp.func_74779_i("block")));
            if (block != null) {
                boolean inferItem = cmp.func_74767_n("inferItem");
                String[] legacyIDs = IvNBTHelper.readNBTStrings((String)"legacyIDs", (NBTTagCompound)cmp);
                RecurrentComplex.cremapper.registerLegacyIDs(block, inferItem, legacyIDs);
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - could not find block!");
            }
        } else if (this.isMessage("registerLegacyItemIds", message, NBTTagCompound.class)) {
            NBTTagCompound cmp = message.getNBTValue();
            Item item = RecurrentComplex.specialRegistry.itemFromID(new ResourceLocation(cmp.func_74779_i("item")));
            if (item != null) {
                String[] legacyIDs = IvNBTHelper.readNBTStrings((String)"legacyIDs", (NBTTagCompound)cmp);
                RecurrentComplex.cremapper.registerLegacyIDs(item, legacyIDs);
            } else {
                this.getLogger().warn("Could not handle message with key '" + message.key + "' - could not find item!");
            }
        }
        return false;
    }
}

