/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext;

import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.IntTilesPacket;
import hunternif.mc.atlas.network.client.ShortTilesPacket;
import hunternif.mc.atlas.util.IntVec2;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.MathUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;

public class ExtBiomeData
extends WorldSavedData {
    private static final int VERSION = 1;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_DIMENSION_MAP_LIST = "dimMap";
    private static final String TAG_DIMENSION_ID = "dimID";
    private static final String TAG_BIOME_IDS = "biomeIDs";
    private final Map<Integer, Map<IntVec2, Integer>> dimensionMap = new ConcurrentHashMap<Integer, Map<IntVec2, Integer>>(2, 0.75f, 2);
    private final IntVec2 tempCoords = new IntVec2(0.0, 0.0);

    public ExtBiomeData(String key) {
        super(key);
    }

    public void func_76184_a(NBTTagCompound compound) {
        int version = compound.func_74762_e(TAG_VERSION);
        if (version < 1) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 1);
            this.func_76185_a();
        }
        NBTTagList dimensionMapList = compound.func_150295_c(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.func_74745_c(); ++d) {
            NBTTagCompound tag = dimensionMapList.func_150305_b(d);
            int dimensionID = tag.func_74762_e(TAG_DIMENSION_ID);
            Map<IntVec2, Integer> biomeMap = this.getBiomesInDimension(dimensionID);
            int[] intArray = tag.func_74759_k(TAG_BIOME_IDS);
            for (int i = 0; i < intArray.length; i += 3) {
                IntVec2 coords = new IntVec2((double)intArray[i], (double)intArray[i + 1]);
                biomeMap.put(coords, intArray[i + 2]);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a(TAG_VERSION, 1);
        NBTTagList dimensionMapList = new NBTTagList();
        for (Integer dimension : this.dimensionMap.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(TAG_DIMENSION_ID, dimension.intValue());
            Map<IntVec2, Integer> biomeMap = this.getBiomesInDimension(dimension);
            int[] intArray = new int[biomeMap.size() * 3];
            int i = 0;
            for (Map.Entry<IntVec2, Integer> entry : biomeMap.entrySet()) {
                intArray[i++] = entry.getKey().x;
                intArray[i++] = entry.getKey().y;
                intArray[i++] = entry.getValue();
            }
            tag.func_74783_a(TAG_BIOME_IDS, intArray);
            dimensionMapList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(TAG_DIMENSION_MAP_LIST, (NBTBase)dimensionMapList);
        return compound;
    }

    private Map<IntVec2, Integer> getBiomesInDimension(int dimension) {
        return this.dimensionMap.computeIfAbsent(dimension, k -> new ConcurrentHashMap(2, 0.75f, 2));
    }

    public int getBiomeIdAt(int dimension, int x, int z) {
        Integer biomeID = this.getBiomesInDimension(dimension).get(this.tempCoords.set(x, z));
        return biomeID == null ? -1 : biomeID;
    }

    public void setBiomeIdAt(int dimension, int x, int z, int biomeID) {
        this.getBiomesInDimension(dimension).put(new IntVec2((double)x, (double)z), biomeID);
        this.func_76185_a();
    }

    public void removeBiomeAt(int dimension, int x, int z) {
        this.getBiomesInDimension(dimension).remove(this.tempCoords.set(x, z));
        this.func_76185_a();
    }

    public void syncOnPlayer(EntityPlayer player) {
        for (Integer dimension : this.dimensionMap.keySet()) {
            Map<IntVec2, Integer> biomes = this.getBiomesInDimension(dimension);
            boolean useInt = biomes.keySet().stream().anyMatch(p -> MathUtil.exceedsShort(p.x, p.y));
            AbstractMessage.AbstractClientMessage packet = useInt ? new IntTilesPacket(dimension) : new ShortTilesPacket(dimension);
            for (Map.Entry<IntVec2, Integer> entry : biomes.entrySet()) {
                packet.addTile(entry.getKey().x, entry.getKey().y, entry.getValue());
            }
            PacketDispatcher.sendTo(packet, (EntityPlayerMP)player);
        }
        Log.info("Sent custom biome data to player %s", player.func_70005_c_());
    }
}

