/*
 * Decompiled with CFR 0.152.
 */
package bq_msi.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_msi.client.gui.PanelTaskRCLocate;
import bq_msi.tasks.ITaskTickable;
import bq_msi.tasks.factory.FactoryTaskRCLocate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TaskRCLocate
implements ITaskTickable {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public String structure = "";
    public String name = "New Structure";
    public int dim = 0;
    public boolean hideInfo = false;

    public ResourceLocation getFactoryID() {
        return FactoryTaskRCLocate.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_msi.task.rc_locate";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
        } else {
            this.completeUsers.remove(uuid);
        }
    }

    @Override
    public void tickTask(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (pInfo.PLAYER.field_70173_aa % 100 == 0) {
            this.internalDetect(pInfo, quest);
        }
    }

    public void detect(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        this.internalDetect(pInfo, quest);
    }

    public boolean DataReadCompare(String regionName, String structure, int dim, int xPos, int zPos) {
        File fileName = new File(DimensionManager.getCurrentSaveRootDirectory() + File.separator + "data" + File.separator + "QuestStructure" + File.separator + dim + File.separator + regionName + ".txt");
        try {
            String line;
            FileReader fileReader = new FileReader(fileName);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.contains(structure)) continue;
                String[] tokens = line.split(",");
                int minX = Integer.parseInt(tokens[1]);
                int maxX = Integer.parseInt(tokens[2]);
                int minZ = Integer.parseInt(tokens[3]);
                int maxZ = Integer.parseInt(tokens[4]);
                if (minX >= xPos || xPos >= maxX || minZ >= zPos || zPos >= maxZ) continue;
                bufferedReader.close();
                return true;
            }
            bufferedReader.close();
            return false;
        }
        catch (IOException ex) {
            if (ex instanceof FileNotFoundException) {
                return false;
            }
            System.out.println(ex);
            return false;
        }
    }

    public String convertPosToRegion(int xPos, int zPos) {
        int regionX = Math.round(xPos / 512);
        int regionZ = Math.round(zPos / 512);
        String regionName = "r." + Integer.toString(regionX) + "." + Integer.toString(regionZ);
        return regionName;
    }

    private void internalDetect(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (!pInfo.PLAYER.func_70089_S() || !(pInfo.PLAYER instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)pInfo.PLAYER;
        BlockPos pos = playerMP.func_180425_c();
        int xPos = pos.func_177958_n();
        int zPos = pos.func_177952_p();
        String regionName = this.convertPosToRegion(xPos, zPos);
        if (playerMP.field_71093_bK == this.dim && !StringUtils.func_151246_b((String)this.structure) && this.DataReadCompare(regionName, this.structure, this.dim, xPos, zPos)) {
            pInfo.ALL_UUIDS.forEach(uuid -> {
                if (!this.isComplete((UUID)uuid)) {
                    this.setComplete((UUID)uuid);
                }
            });
            pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("dimension", this.dim);
        nbt.func_74778_a("structure", this.structure);
        nbt.func_74778_a("name", this.name);
        nbt.func_74757_a("hideInfo", this.hideInfo);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.dim = nbt.func_74762_e("dimension");
        this.structure = nbt.func_74779_i("structure");
        this.name = nbt.func_74779_i("name");
        this.hideInfo = nbt.func_74767_n("hideInfo");
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        this.completeUsers.forEach(uuid -> {
            if (users == null || users.contains(uuid)) {
                jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
            }
        });
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        return nbt;
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskRCLocate(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }
}

