/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.compat.mod;

import com.charles445.simpledifficulty.SimpleDifficulty;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.temperature.ModifierBase;
import java.lang.reflect.Method;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SereneSeasonsModifier
extends ModifierBase {
    private Class SeasonHelper;
    private Class ISeasonState;
    private Class SubSeason;
    private Method getSeasonState;
    private Method getSubSeason;
    private boolean enabled;

    public SereneSeasonsModifier() {
        super("SereneSeasons");
        try {
            this.SeasonHelper = Class.forName("sereneseasons.api.season.SeasonHelper");
            this.ISeasonState = Class.forName("sereneseasons.api.season.ISeasonState");
            this.SubSeason = Class.forName("sereneseasons.api.season.Season$SubSeason");
            this.getSeasonState = this.SeasonHelper.getDeclaredMethod("getSeasonState", World.class);
            this.getSubSeason = this.ISeasonState.getDeclaredMethod("getSubSeason", new Class[0]);
            this.enabled = true;
            if (!this.SubSeason.isEnum()) {
                SimpleDifficulty.logger.error("ModifierSeason reflection failed! SubSeason was not an enum! Serene Seasons compatibility is now disabled!");
                this.enabled = false;
            }
        }
        catch (Exception e) {
            SimpleDifficulty.logger.error("ModifierSeason reflection failed! Serene Seasons compatibility is now disabled!", (Throwable)e);
            this.enabled = false;
        }
    }

    @Override
    public float getWorldInfluence(World world, BlockPos pos) {
        if (this.enabled && world.field_73011_w.func_76569_d() && ModConfig.server.compatibility.toggles.sereneSeasons) {
            try {
                switch (((Enum)this.getSubSeason.invoke(this.ISeasonState.cast(this.getSeasonState.invoke(null, world)), new Object[0])).name()) {
                    case "EARLY_AUTUMN": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonEarlyAutumn, world, pos);
                    }
                    case "EARLY_SPRING": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonEarlySpring, world, pos);
                    }
                    case "EARLY_SUMMER": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonEarlySummer, world, pos);
                    }
                    case "EARLY_WINTER": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonEarlyWinter, world, pos);
                    }
                    case "LATE_AUTUMN": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonLateAutumn, world, pos);
                    }
                    case "LATE_SPRING": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonLateSpring, world, pos);
                    }
                    case "LATE_SUMMER": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonLateSummer, world, pos);
                    }
                    case "LATE_WINTER": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonLateWinter, world, pos);
                    }
                    case "MID_AUTUMN": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonMidAutumn, world, pos);
                    }
                    case "MID_SPRING": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonMidSpring, world, pos);
                    }
                    case "MID_SUMMER": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonMidSummer, world, pos);
                    }
                    case "MID_WINTER": {
                        return this.applyUndergroundEffect(ModConfig.server.compatibility.sereneseasons.seasonMidWinter, world, pos);
                    }
                }
                return 0.0f;
            }
            catch (Exception e) {
                SimpleDifficulty.logger.error("ModifierSeason reflection failed during getWorldInfluence! Serene Seasons compatibility is now disabled!", (Throwable)e);
                this.enabled = false;
            }
        }
        return 0.0f;
    }
}

