/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.client.gui;

import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.SDItems;
import com.charles445.simpledifficulty.api.config.QuickConfig;
import com.charles445.simpledifficulty.api.temperature.ITemperatureCapability;
import com.charles445.simpledifficulty.api.temperature.TemperatureEnum;
import com.charles445.simpledifficulty.api.temperature.TemperatureUtil;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.util.RenderUtil;
import com.charles445.simpledifficulty.util.WorldUtil;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TemperatureGui {
    private final Minecraft mc = Minecraft.func_71410_x();
    private int updateCounter = 0;
    private final Random rand = new Random();
    public static final ResourceLocation ICONS = new ResourceLocation("simpledifficulty:textures/gui/icons.png");
    public static final ResourceLocation TEMPHUD = new ResourceLocation("simpledifficulty:textures/gui/temphud.png");
    private static final int classicTexturePos_X = 0;
    private static final int classicTexturePos_Y = 32;
    private static final int classicTextureWidth = 16;
    private static final int classicTextureHeight = 16;
    private static final int modernTexturePos_X = 0;
    private static final int modernTexturePos_Y = 0;
    private static final int modernTextureWidth = 16;
    private static final int modernTextureHeight = 16;
    private static final int modernFeelPos_X = 0;
    private static final int modernFeelPos_Y = 16;
    private static final int modernFeelWidth = 32;
    private static final int modernFeelHeight = 32;
    private static final int modernArrowPos_X = 0;
    private static final int modernArrowPos_Y = 144;
    private static final int modernArrowFrames = 14;
    private int oldTemperature = -1;
    private int frameCounterClassic = -1;
    private int frameCounterModern = -1;
    private boolean risingTemperature = false;
    private boolean startAnimation = false;
    private boolean shakeSide = false;
    private static final int texturepos_Y_alt_OVR = 80;
    private static final int texturepos_Y_alt_BG = 96;
    private int alternateTemperature = 0;
    private int worldThermometerTemperature = 0;
    private boolean hasThermometer = false;
    private static final int texturepos_X_therm = 0;
    private static final int texturepos_Y_therm = 192;
    private static final int thermometer_per_row = 8;
    private static final int textureWidthTherm = 16;
    private static final int textureHeightTherm = 16;

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && QuickConfig.isTemperatureEnabled() && this.mc.field_71442_b.func_78763_f()) {
            this.rand.setSeed(this.updateCounter * 445);
            boolean classic = ModConfig.client.classicHUDTemperature;
            if (classic) {
                this.bind(ICONS);
            } else {
                this.bind(TEMPHUD);
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ITemperatureCapability capability = SDCapabilities.getTemperatureData((EntityPlayer)player);
            ScaledResolution resolution = event.getResolution();
            GlStateManager.func_179147_l();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            if (classic) {
                this.renderClassicTemperatureIcon(resolution.func_78326_a(), resolution.func_78328_b(), capability.getTemperatureLevel());
            } else {
                this.renderTemperatureIcon(resolution.func_78326_a(), resolution.func_78328_b(), capability.getTemperatureLevel());
            }
            GlStateManager.func_179084_k();
            this.bind(Gui.field_110324_m);
        }
    }

    private int getTempHudFeelBGX(int temperature) {
        int bgx = 0;
        bgx = temperature < 6 || temperature >= 20 ? 0 : (temperature / 2 - 2) * 32;
        return bgx;
    }

    private int getTempHudFeelBGY(int temperature) {
        if (temperature >= 20) {
            return 32;
        }
        return 0;
    }

    private int getTempHudCoreBGX(int temperature) {
        int bgx = 0;
        boolean animated = false;
        if (temperature < 6) {
            bgx = 0;
            animated = true;
        } else if (temperature >= 20) {
            bgx = 192;
            animated = true;
        } else {
            bgx = (temperature / 2 + 2) * 16;
        }
        if (animated) {
            bgx = temperature < 12 ? (bgx += this.updateCounter % 5 * 16) : (bgx += this.updateCounter % 4 * 16);
        }
        return bgx;
    }

    private void renderTemperatureIcon(int width, int height, int temperature) {
        TemperatureEnum tempEnum = TemperatureUtil.getTemperatureEnum(temperature);
        int bgXOffset = this.getTempHudCoreBGX(temperature);
        int x = width / 2 - 8;
        int y = height - 54;
        int xOffset = 0;
        int yOffset = 0;
        int shakeFrequency = this.getShakeFrequency(tempEnum, temperature);
        if (shakeFrequency > 0) {
            if (this.updateCounter % shakeFrequency == 0) {
                int shakeCheck = this.updateCounter / shakeFrequency;
                this.shakeSide = shakeCheck % 2 == 0;
            }
            int n = xOffset = this.shakeSide ? 1 : -1;
        }
        if (ModConfig.client.alternateTemp) {
            RenderUtil.drawTexturedModalRect(x - 8 + xOffset, y - 8 + yOffset, 0 + this.getTempHudFeelBGX(this.alternateTemperature), 16 + this.getTempHudFeelBGY(this.alternateTemperature), 32, 32);
            RenderUtil.drawTexturedModalRect(x + xOffset, y + yOffset, 0 + bgXOffset, 0, 16, 16);
        } else {
            RenderUtil.drawTexturedModalRect(x + xOffset, y + yOffset, 0 + bgXOffset, 0, 16, 16);
        }
        this.renderTemperatureChangeAnimation(false, x, y, temperature);
        this.renderThermometer(x, y);
    }

    private void renderClassicTemperatureIcon(int width, int height, int temperature) {
        TemperatureEnum tempEnum = TemperatureUtil.getTemperatureEnum(temperature);
        int bgXOffset = 16 * tempEnum.ordinal();
        int x = width / 2 - 8;
        int y = height - 54;
        int xOffset = 0;
        int yOffset = 0;
        int shakeFrequency = this.getShakeFrequency(tempEnum, temperature);
        if (shakeFrequency > 0) {
            if (this.updateCounter % shakeFrequency == 0) {
                int shakeCheck = this.updateCounter / shakeFrequency;
                this.shakeSide = shakeCheck % 2 == 0;
            }
            int n = xOffset = this.shakeSide ? 1 : -1;
        }
        if (ModConfig.client.alternateTemp) {
            int outsideOffset = 16 * TemperatureUtil.getTemperatureEnum(this.alternateTemperature).ordinal();
            RenderUtil.drawTexturedModalRect(x + xOffset, y + yOffset, 0 + outsideOffset, 96, 16, 16);
            RenderUtil.drawTexturedModalRect(x + xOffset, y + yOffset, 0 + bgXOffset, 80, 16, 16);
        } else {
            RenderUtil.drawTexturedModalRect(x + xOffset, y + yOffset, 0 + bgXOffset, 32, 16, 16);
        }
        this.renderTemperatureChangeAnimation(true, x, y, temperature);
        this.renderThermometer(x, y);
    }

    private void renderTemperatureChangeAnimation(boolean classic, int x, int y, int temperature) {
        if (this.oldTemperature == -1) {
            this.oldTemperature = temperature;
        }
        if (this.oldTemperature != temperature) {
            this.risingTemperature = this.oldTemperature < temperature;
            this.oldTemperature = temperature;
            this.startAnimation = true;
        }
        if (classic) {
            if (this.frameCounterClassic >= 0) {
                int ovrXOffset = 16 * this.frameCounterClassic;
                int ovrYOffset = (this.risingTemperature ? 1 : 2) * 16;
                RenderUtil.drawTexturedModalRect(x, y, 0 + ovrXOffset, 32 + ovrYOffset, 16, 16);
            }
        } else if (this.frameCounterModern >= 0) {
            int ovrXOffset = (14 - this.frameCounterModern) * 16;
            int ovrYOffset = (this.risingTemperature ? 1 : 0) * 16;
            RenderUtil.drawTexturedModalRect(x, y, 0 + ovrXOffset, 144 + ovrYOffset, 16, 16);
        }
    }

    private void renderThermometer(int x, int y) {
        if (this.hasThermometer && ModConfig.client.thermometer.hudThermometer && ModConfig.client.thermometer.enableThermometer) {
            int therm_position = this.worldThermometerTemperature - TemperatureEnum.FREEZING.getLowerBound();
            int therm_x = therm_position % 8 * 16 + 0;
            int therm_y = therm_position / 8 * 16 + 192;
            int therm_xOffset = ModConfig.client.thermometer.hudThermometerX;
            int therm_yOffset = ModConfig.client.thermometer.hudThermometerY;
            RenderUtil.drawTexturedModalRect(x + therm_xOffset, y - 18 + therm_yOffset, therm_x, therm_y, 16, 16);
        }
    }

    private int getShakeFrequency(TemperatureEnum tempEnum, int temperature) {
        int shakeFrequency = 0;
        if (tempEnum == TemperatureEnum.FREEZING) {
            shakeFrequency = temperature == TemperatureEnum.FREEZING.getUpperBound() ? 0 : (temperature > TemperatureEnum.FREEZING.getMiddle() + 1 ? 2 : 1);
        } else if (tempEnum == TemperatureEnum.BURNING) {
            shakeFrequency = temperature == TemperatureEnum.BURNING.getLowerBound() ? 0 : (temperature >= TemperatureEnum.BURNING.getMiddle() ? 1 : 2);
        }
        return shakeFrequency;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.mc.func_147113_T()) {
            ++this.updateCounter;
            if (this.frameCounterClassic >= 0) {
                --this.frameCounterClassic;
            }
            if (this.frameCounterModern >= 0) {
                --this.frameCounterModern;
            }
            if (this.startAnimation) {
                this.frameCounterClassic = 11;
                this.frameCounterModern = 14;
                this.startAnimation = false;
            }
            if (this.updateCounter % 15 == 12 && QuickConfig.isTemperatureEnabled() && this.mc.field_71439_g != null) {
                EntityPlayerSP player = this.mc.field_71439_g;
                World world = player.func_130014_f_();
                if (ModConfig.client.alternateTemp) {
                    this.alternateTemperature = TemperatureUtil.clampTemperature(TemperatureUtil.getPlayerTargetTemperature((EntityPlayer)player));
                }
                if (ModConfig.client.thermometer.hudThermometer && ModConfig.client.thermometer.enableThermometer) {
                    this.worldThermometerTemperature = TemperatureUtil.clampTemperature(WorldUtil.calculateClientWorldEntityTemperature(world, (Entity)player));
                    this.hasThermometer = player.field_71071_by.func_70431_c(new ItemStack(SDItems.thermometer));
                }
            }
        }
    }

    private void bind(ResourceLocation resource) {
        this.mc.func_110434_K().func_110577_a(resource);
    }
}

