/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.capability;

import com.charles445.simpledifficulty.api.temperature.ITemperatureCapability;
import com.charles445.simpledifficulty.api.temperature.TemporaryModifier;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class TemperatureStorage
implements Capability.IStorage<ITemperatureCapability> {
    private static final String temperatureLevel = "temperatureLevel";
    private static final String temperatureTickTimer = "temperatureTickTimer";
    private static final String temporaryModifiers = "temporaryModifiers";
    private static final String temperatureDamageCounter = "temperatureDamageCounter";
    private static final String NBT_name = "name";
    private static final String NBT_temperature = "temperature";
    private static final String NBT_duration = "duration";

    public NBTBase writeNBT(Capability<ITemperatureCapability> capability, ITemperatureCapability instance, EnumFacing side) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList temporaryList = new NBTTagList();
        ImmutableMap<String, TemporaryModifier> tempModMap = instance.getTemporaryModifiers();
        for (Map.Entry entry : tempModMap.entrySet()) {
            TemporaryModifier tempMod = (TemporaryModifier)entry.getValue();
            NBTTagCompound tempModCompound = new NBTTagCompound();
            tempModCompound.func_74778_a(NBT_name, (String)entry.getKey());
            tempModCompound.func_74776_a(NBT_temperature, tempMod.temperature);
            tempModCompound.func_74768_a(NBT_duration, tempMod.duration);
            temporaryList.func_74742_a((NBTBase)tempModCompound);
        }
        compound.func_74768_a(temperatureLevel, instance.getTemperatureLevel());
        compound.func_74768_a(temperatureTickTimer, instance.getTemperatureTickTimer());
        compound.func_74768_a(temperatureDamageCounter, instance.getTemperatureDamageCounter());
        compound.func_74782_a(temporaryModifiers, (NBTBase)temporaryList);
        return compound;
    }

    public void readNBT(Capability<ITemperatureCapability> capability, ITemperatureCapability instance, EnumFacing side, NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            if (compound.func_74764_b(temperatureLevel)) {
                instance.setTemperatureLevel(compound.func_74762_e(temperatureLevel));
            }
            if (compound.func_74764_b(temperatureTickTimer)) {
                instance.setTemperatureTickTimer(compound.func_74762_e(temperatureTickTimer));
            }
            if (compound.func_74764_b(temperatureDamageCounter)) {
                instance.setTemperatureDamageCounter(compound.func_74762_e(temperatureDamageCounter));
            }
            if (compound.func_74764_b(temporaryModifiers)) {
                instance.clearTemporaryModifiers();
                NBTTagList temporaryModList = compound.func_150295_c(temporaryModifiers, 10);
                for (NBTTagCompound tempComp : temporaryModList) {
                    if (!tempComp.func_74764_b(NBT_name) || !tempComp.func_74764_b(NBT_temperature) || !tempComp.func_74764_b(NBT_duration)) continue;
                    instance.setTemporaryModifier(tempComp.func_74779_i(NBT_name), tempComp.func_74760_g(NBT_temperature), tempComp.func_74762_e(NBT_duration));
                }
            }
        }
    }
}

