/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.block;

import com.charles445.simpledifficulty.SimpleDifficulty;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.tileentity.TileEntityTemperature;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTemperature
extends BlockContainer {
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");
    private final float temperature;

    public BlockTemperature(float temperature) {
        super(Material.field_151573_f);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185852_e);
        this.temperature = temperature;
    }

    public float getActiveTemperatureMult() {
        return this.temperature;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            boolean enabled = (Boolean)state.func_177229_b((IProperty)ENABLED);
            boolean powered = world.func_175640_z(pos);
            if (enabled && !powered) {
                this.turnOff(world, pos, state);
            } else if (!enabled && powered) {
                this.turnOn(world, pos, state);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            boolean enabled = (Boolean)state.func_177229_b((IProperty)ENABLED);
            boolean powered = world.func_175640_z(pos);
            if (enabled && !powered) {
                world.func_175684_a(pos, (Block)this, 4);
            } else if (!enabled && powered) {
                this.turnOn(world, pos, state);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue() && !world.func_175640_z(pos)) {
            this.turnOff(world, pos, state);
        }
    }

    private void turnOff(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false)), 2);
    }

    private void turnOn(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)), 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue() && rand.nextFloat() <= 0.33f) {
            this.createRandomParticle(world, pos, rand);
        }
    }

    private void createRandomParticle(World world, BlockPos pos, Random rand) {
        double x_a = 0.125;
        double z_a = 0.125;
        double x_b = 0.0;
        double z_b = 0.0;
        double endoff = 0.875;
        double thickness = 0.2;
        switch (rand.nextInt(4)) {
            case 0: {
                x_b = endoff;
                z_b = thickness;
                break;
            }
            case 1: {
                x_a = endoff - thickness;
                x_b = endoff;
                z_b = endoff;
                break;
            }
            case 2: {
                x_b = endoff;
                z_a = endoff - thickness;
                z_b = endoff;
                break;
            }
            case 3: {
                x_b = thickness;
                z_b = endoff;
                break;
            }
        }
        double x_r = rand.nextDouble() * (x_b - x_a);
        double z_r = rand.nextDouble() * (z_b - z_a);
        if (ModConfig.client.heaterParticles) {
            SimpleDifficulty.proxy.spawnClientParticle(world, this.temperature >= 0.0f ? "HEATER" : "CHILLER", x_a + x_r + (double)pos.func_177958_n(), 0.775 + (double)pos.func_177956_o(), z_a + z_r + (double)pos.func_177952_p(), 0.0, 0.05, 0.0);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)ENABLED) != false ? 0xF000F0 : super.func_185484_c(state, source, pos);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityTemperature();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ENABLED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ENABLED});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            return 7;
        }
        return 0;
    }
}

