/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.common.ModConfig;
import artifacts.common.item.BaubleBase;
import artifacts.common.util.BaubleHelper;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class AttributeModifierBauble
extends BaubleBase {
    private final Set<ExtendedAttributeModifier> attributeModifiers;

    public AttributeModifierBauble(String name, BaubleType type, ExtendedAttributeModifier ... attributeModifiers) {
        super(name, type);
        this.attributeModifiers = new HashSet<ExtendedAttributeModifier>(Arrays.asList(attributeModifiers));
    }

    @Override
    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        super.onEquipped(stack, player);
        if (player instanceof EntityPlayer) {
            this.applyModifiers(null, (EntityPlayer)player);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        super.onUnequipped(stack, player);
        if (player instanceof EntityPlayer) {
            this.applyModifiers(stack, (EntityPlayer)player);
        }
    }

    private void applyModifiers(@Nullable ItemStack excludedStack, EntityPlayer player) {
        IBaublesItemHandler baublesHandler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        HashSet<ExtendedAttributeModifier> modifiers = new HashSet<ExtendedAttributeModifier>();
        for (int slot : BaubleType.TRINKET.getValidSlots()) {
            ItemStack stack = baublesHandler.getStackInSlot(slot);
            if (!(stack.func_77973_b() instanceof AttributeModifierBauble) || stack == excludedStack) continue;
            modifiers.addAll(((AttributeModifierBauble)stack.func_77973_b()).attributeModifiers);
        }
        modifiers.retainAll(this.attributeModifiers);
        Object object = this.attributeModifiers.iterator();
        while (object.hasNext()) {
            ExtendedAttributeModifier modifier = (ExtendedAttributeModifier)object.next();
            IAttributeInstance instance = player.func_110140_aT().func_111151_a(modifier.affectedAttribute);
            if (instance.func_111127_a(modifier.id) == null) continue;
            instance.func_188479_b(modifier.id);
        }
        int amount = BaubleHelper.getAmountBaubleEquipped(player, this);
        for (ExtendedAttributeModifier modifier : modifiers) {
            player.func_110140_aT().func_111151_a(modifier.affectedAttribute).func_111121_a(new AttributeModifier(modifier.id, modifier.name, modifier.getValue() * (double)amount, modifier.getOperation()));
        }
    }

    public static class ExtendedAttributeModifier {
        public final UUID id;
        public final String name;
        public final IAttribute affectedAttribute;

        public ExtendedAttributeModifier(UUID id, String nameIn, IAttribute affectedAttribute) {
            this.id = id;
            this.name = nameIn;
            this.affectedAttribute = affectedAttribute;
        }

        public double getValue() {
            if (this.affectedAttribute == SharedMonsterAttributes.field_111264_e) {
                return ModConfig.general.attackDamageBoost;
            }
            if (this.affectedAttribute == SharedMonsterAttributes.field_188790_f) {
                return ModConfig.general.attackSpeedBoost;
            }
            if (this.affectedAttribute == SharedMonsterAttributes.field_188792_h) {
                return ModConfig.general.luckBoost;
            }
            return 0.0;
        }

        public int getOperation() {
            if (this.affectedAttribute == SharedMonsterAttributes.field_111264_e) {
                return ModConfig.general.attackDamageOperation;
            }
            if (this.affectedAttribute == SharedMonsterAttributes.field_188790_f) {
                return ModConfig.general.attackSpeedOperation;
            }
            if (this.affectedAttribute == SharedMonsterAttributes.field_188792_h) {
                return ModConfig.general.luckOperation;
            }
            return 0;
        }
    }
}

