/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.model.layer;

import artifacts.client.model.ModelCloak;
import artifacts.client.model.layer.LayerBauble;
import artifacts.common.init.ModItems;
import artifacts.common.util.RenderHelper;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LayerCloak
extends LayerBauble {
    private static final ResourceLocation CLOAK_NORMAL = new ResourceLocation("artifacts", "textures/entity/layer/star_cloak.png");
    private static final ResourceLocation CLOAK_OVERLAY = new ResourceLocation("artifacts", "textures/entity/layer/star_cloak_overlay.png");
    private static final ModelCloak CLOAK_MODEL = new ModelCloak();

    public LayerCloak(RenderPlayer renderPlayer) {
        super(renderPlayer);
    }

    @Override
    protected void renderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderChest(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    private void renderChest(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)ModItems.STAR_CLOAK) == -1 || !RenderHelper.shouldRenderInSlot(player, EntityEquipmentSlot.CHEST)) {
            return;
        }
        ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(BaubleType.BODY.getValidSlots()[0]);
        if (stack.func_77973_b() != ModItems.STAR_CLOAK || !RenderHelper.shouldItemStackRender(player, stack)) {
            return;
        }
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        boolean hoodUp = RenderHelper.shouldRenderInSlot(player, EntityEquipmentSlot.HEAD) && (BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)ModItems.DRINKING_HAT) == -1 || !RenderHelper.shouldItemStackRender(player, BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(BaubleType.HEAD.getValidSlots()[0])));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CLOAK_NORMAL);
        this.renderBody(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, hoodUp);
        this.renderHead(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, hoodUp);
        float lastLightmapX = OpenGlHelper.lastBrightnessX;
        float lastLightmapY = OpenGlHelper.lastBrightnessY;
        int light = 0xF000F0;
        int lightmapX = light % 65536;
        int lightmapY = light / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CLOAK_OVERLAY);
        this.renderBody(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, hoodUp);
        this.renderHead(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, hoodUp);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastLightmapX, (float)lastLightmapY);
    }

    private void renderBody(EntityPlayer player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale, boolean hoodUp) {
        GlStateManager.func_179094_E();
        this.modelPlayer.field_78115_e.func_78794_c(scale);
        CLOAK_MODEL.renderCloak((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, hoodUp);
        GlStateManager.func_179121_F();
    }

    private void renderHead(EntityPlayer player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale, boolean hoodUp) {
        GlStateManager.func_179094_E();
        this.modelPlayer.field_78116_c.func_78794_c(scale);
        CLOAK_MODEL.renderHood((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, hoodUp);
        GlStateManager.func_179121_F();
    }
}

