/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.model.layer;

import artifacts.client.model.ModelAntidoteVessel;
import artifacts.client.model.ModelBottledCloud;
import artifacts.client.model.ModelBubbleWrap;
import artifacts.client.model.ModelObsidianSkull;
import artifacts.client.model.layer.LayerBauble;
import artifacts.common.init.ModItems;
import artifacts.common.util.RenderHelper;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LayerBelt
extends LayerBauble {
    private static final ResourceLocation BOTTLED_CLOUD = new ResourceLocation("artifacts", "textures/entity/layer/bottled_cloud.png");
    private static final ResourceLocation BOTTLED_FART = new ResourceLocation("artifacts", "textures/entity/layer/bottled_fart.png");
    private static final ResourceLocation ANTIDOTE_VESSEL = new ResourceLocation("artifacts", "textures/entity/layer/antidote_vessel.png");
    private static final ResourceLocation BUBBLE_WRAP = new ResourceLocation("artifacts", "textures/entity/layer/bubble_wrap.png");
    private static final ResourceLocation OBSIDIAN_SKULL = new ResourceLocation("artifacts", "textures/entity/layer/obsidian_skull.png");
    private static final ModelBase BOTTLE_MODEL = new ModelBottledCloud();
    private static final ModelBase ANTIDOTE_MODEL = new ModelAntidoteVessel();
    private static final ModelBase BUBBLE_MODEL = new ModelBubbleWrap();
    private static final ModelBase SKULL_MODEL = new ModelObsidianSkull();

    public LayerBelt(RenderPlayer renderPlayer) {
        super(renderPlayer);
    }

    @Override
    protected void renderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderBelt(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    private void renderBelt(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelBase belt = this.setTexturesGetModel(player);
        if (belt == null) {
            return;
        }
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        this.modelPlayer.field_78115_e.func_78794_c(scale);
        belt.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    private ModelBase setTexturesGetModel(EntityPlayer player) {
        ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(BaubleType.BELT.getValidSlots()[0]);
        if (!RenderHelper.shouldItemStackRender(player, stack)) {
            return null;
        }
        ResourceLocation textures = this.getTextures(stack);
        if (textures != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textures);
            if (stack.func_77973_b() == ModItems.ANTIDOTE_VESSEL) {
                return ANTIDOTE_MODEL;
            }
            if (stack.func_77973_b() == ModItems.BUBBLE_WRAP) {
                return BUBBLE_MODEL;
            }
            if (stack.func_77973_b() == ModItems.OBSIDIAN_SKULL) {
                return SKULL_MODEL;
            }
            return BOTTLE_MODEL;
        }
        return null;
    }

    @Nullable
    private ResourceLocation getTextures(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.BOTTLED_CLOUD) {
            return BOTTLED_CLOUD;
        }
        if (stack.func_77973_b() == ModItems.BOTTLED_FART) {
            return BOTTLED_FART;
        }
        if (stack.func_77973_b() == ModItems.ANTIDOTE_VESSEL) {
            return ANTIDOTE_VESSEL;
        }
        if (stack.func_77973_b() == ModItems.BUBBLE_WRAP) {
            return BUBBLE_WRAP;
        }
        if (stack.func_77973_b() == ModItems.OBSIDIAN_SKULL) {
            return OBSIDIAN_SKULL;
        }
        return null;
    }
}

