/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.items;

import com.mujmajnkraft.bettersurvival.config.ForgeConfigHandler;
import com.mujmajnkraft.bettersurvival.init.ModPotions;
import com.mujmajnkraft.bettersurvival.items.ItemCustomWeapon;
import com.mujmajnkraft.bettersurvival.recipe.CrushingRecipe;
import java.util.List;
import net.minecraft.block.BlockGlass;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHammer
extends ItemCustomWeapon {
    public final int stunduration;

    public ItemHammer(Item.ToolMaterial material) {
        super(material, ForgeConfigHandler.weapons.hammerDmgMod, ForgeConfigHandler.weapons.hammerSpd);
        this.setRegistryName("mujmajnkraftsbettersurvival", "item" + material.name().toLowerCase() + "hammer");
        this.func_77655_b(material.name().toLowerCase() + "hammer");
        this.stunduration = 50;
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.FAIL;
        }
        float d = Math.min(super.getAttackDamage(), 9.0f) + 1.0f;
        double xd = 1.0;
        double yd = 1.0;
        double zd = 1.0;
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            xd += 9.0;
            zd += 9.0;
        } else if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
            yd += 9.0;
            zd += 9.0;
        } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            xd += 9.0;
            yd += 9.0;
        }
        for (EntityLivingBase entitylivingbase : playerIn.func_130014_f_().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72314_b(xd, yd, zd))) {
            if (entitylivingbase == playerIn || !(entitylivingbase.func_174818_b(pos) < (double)(2.0f * d)) || !entitylivingbase.field_70122_E) continue;
            entitylivingbase.func_70653_a((Entity)playerIn, 0.4f, (double)MathHelper.func_76126_a((float)(playerIn.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(playerIn.field_70177_z * ((float)Math.PI / 180)))));
            entitylivingbase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)playerIn), (float)((double)(this.getAttackDamage() / 2.0f + 1.5f) * (1.0 - entitylivingbase.func_174818_b(pos) / 20.0)));
            PotionEffect potioneffectIn = new PotionEffect(ModPotions.stun, this.stunduration);
            entitylivingbase.func_70690_d(potioneffectIn);
        }
        for (int x = -5; x < 6; ++x) {
            if ((facing == EnumFacing.WEST || facing == EnumFacing.EAST) && x != 0 || !playerIn.field_71075_bZ.field_75099_e) continue;
            for (float y = -5.0f; y < 6.0f; y += 1.0f) {
                if ((facing == EnumFacing.UP || facing == EnumFacing.DOWN) && y != 0.0f) continue;
                for (int z = -5; z < 6; ++z) {
                    BlockPos pos2;
                    if ((facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) && z != 0 || !((float)(x * x) + y * y + (float)(z * z) <= 2.0f * d)) continue;
                    boolean particles = (float)(x * x) + y * y + (float)(z * z) >= 2.0f * (d - 2.0f);
                    BlockPos position = pos.func_177963_a((double)x, (double)y, (double)z);
                    if (worldIn.func_180495_p(position.func_177972_a(facing)).func_177230_c() instanceof BlockGlass) {
                        worldIn.func_175655_b(position.func_177972_a(facing), true);
                    }
                    if (worldIn.func_180495_p(position.func_177972_a(facing.func_176734_d())).func_177230_c() instanceof BlockGlass) {
                        worldIn.func_175655_b(position.func_177972_a(facing.func_176734_d()), true);
                    }
                    if (worldIn.func_180495_p(position).func_177230_c() instanceof BlockGlass) {
                        worldIn.func_175655_b(position, true);
                    }
                    if (worldIn.func_180495_p(position.func_177972_a(facing)).isSideSolid((IBlockAccess)worldIn, position, EnumFacing.UP)) {
                        pos2 = position.func_177972_a(facing);
                        if (worldIn.func_180495_p(pos2.func_177972_a(facing)).isSideSolid((IBlockAccess)worldIn, pos2, EnumFacing.UP)) continue;
                        CrushingRecipe.Crush(playerIn, pos2, particles);
                        continue;
                    }
                    if (!worldIn.func_180495_p(position).isSideSolid((IBlockAccess)worldIn, position, EnumFacing.UP)) {
                        pos2 = position.func_177972_a(facing.func_176734_d());
                        CrushingRecipe.Crush(playerIn, pos2, particles);
                        continue;
                    }
                    CrushingRecipe.Crush(playerIn, position, particles);
                }
            }
        }
        if (!playerIn.func_184812_l_()) {
            playerIn.func_184586_b(hand).func_77972_a(10, (EntityLivingBase)playerIn);
        }
        worldIn.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            playerIn.func_184811_cZ().func_185145_a((Item)this, 200);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String s = I18n.func_135052_a((String)"mujmajnkraftsbettersurvival.hammer.desc", (Object[])new Object[0]);
        tooltip.add(TextFormatting.AQUA + s);
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        target.func_70653_a((Entity)attacker, 0.5f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
        return super.func_77644_a(stack, target, attacker);
    }
}

