/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.items;

import com.google.common.collect.Multimap;
import com.mujmajnkraft.bettersurvival.BetterSurvival;
import com.mujmajnkraft.bettersurvival.config.ForgeConfigHandler;
import com.mujmajnkraft.bettersurvival.integration.InFCompat;
import com.mujmajnkraft.bettersurvival.integration.SoManyEnchantmentsCompat;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentSweepingEdge;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemCustomWeapon
extends Item {
    private final float attackDamage;
    private final double attackSpeed;
    private final Item.ToolMaterial material;

    public ItemCustomWeapon(Item.ToolMaterial material, float damageModifier, float delayModifier) {
        this.material = material;
        this.field_77777_bU = 1;
        this.attackDamage = (3.0f + material.func_78000_c()) * damageModifier;
        this.attackSpeed = (double)-2.4f * (double)delayModifier;
        this.func_77656_e(material.func_77997_a());
        this.func_77637_a(CreativeTabs.field_78037_j);
    }

    public Item.ToolMaterial getMaterial() {
        return this.material;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        if (ForgeConfigHandler.materials.moddedMaterials && OreDictionary.doesOreNameExist((String)("ingot" + this.material.name()))) {
            for (ItemStack stack : OreDictionary.getOres((String)("ingot" + this.material.name()))) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)repair, (boolean)false)) continue;
                return true;
            }
        }
        return super.func_82789_a(toRepair, repair);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (BetterSurvival.isIafLoaded) {
            if (this.material == InFCompat.SILVER) {
                String s = I18n.func_135052_a((String)"silvertools.hurt", (Object[])new Object[0]);
                tooltip.add(TextFormatting.GREEN + s);
            } else if (this.material == InFCompat.JUNGLE_CHITIN || this.material == InFCompat.DESERT_CHITIN) {
                String s = I18n.func_135052_a((String)"myrmextools.hurt", (Object[])new Object[0]);
                tooltip.add(TextFormatting.GREEN + s);
            } else if (this.material == InFCompat.DRAGON_BONE_ICED) {
                String s = I18n.func_135052_a((String)"dragon_sword_ice.hurt1", (Object[])new Object[0]);
                tooltip.add(TextFormatting.GREEN + s);
                s = I18n.func_135052_a((String)"dragon_sword_ice.hurt2", (Object[])new Object[0]);
                tooltip.add(TextFormatting.RED + s);
            } else if (this.material == InFCompat.DRAGON_BONE_FLAMED) {
                String s = I18n.func_135052_a((String)"dragon_sword_fire.hurt1", (Object[])new Object[0]);
                tooltip.add(TextFormatting.GREEN + s);
                s = I18n.func_135052_a((String)"dragon_sword_fire.hurt2", (Object[])new Object[0]);
                tooltip.add(TextFormatting.RED + s);
            }
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return super.func_77644_a(stack, target, attacker);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.attackSpeed, 0));
        }
        return multimap;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (!(enchantment instanceof EnchantmentSweepingEdge) && (enchantment.field_77351_y == EnumEnchantmentType.WEAPON || BetterSurvival.isSMELoaded && SoManyEnchantmentsCompat.isWeaponSMEEnchant(enchantment.field_77351_y))) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }
}

