/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.recipe.IRecipeSerializer;

public final class RecipeJsonHell {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private RecipeJsonHell() {
        throw new IllegalAccessError("Utility class");
    }

    public static void createRecipe(String name, IRecipeSerializer serializer, ItemStack result, Object ... components) {
        RecipeJsonHell.createRecipeFile(serializer.serialize(result, components), name);
    }

    public static void createShapedRecipe(String name, ItemStack result, Object ... components) {
        RecipeJsonHell.createRecipe(name, ShapedSerializer.INSTANCE, result, components);
    }

    public static void createShapelessRecipe(String name, ItemStack result, Object ... components) {
        RecipeJsonHell.createRecipe(name, ShapelessSerializer.INSTANCE, result, components);
    }

    private static JsonObject serializeComponent(Object component) {
        if (component instanceof Item) {
            return RecipeJsonHell.serializeComponent(new ItemStack((Item)component));
        }
        if (component instanceof Block) {
            return RecipeJsonHell.serializeComponent(new ItemStack((Block)component));
        }
        if (component instanceof ItemStack) {
            ItemStack stack = (ItemStack)component;
            JsonObject ret = new JsonObject();
            ret.addProperty("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.addProperty("data", (Number)stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.addProperty("count", (Number)stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                SilentLib.LOGGER.warn("Recipe component contains NBT and cannot be serialized properly: {}", component);
            }
            return ret;
        }
        if (component instanceof String) {
            JsonObject ret = new JsonObject();
            ret.addProperty("type", "forge:ore_dict");
            ret.addProperty("ore", (String)component);
            return ret;
        }
        throw new IllegalArgumentException("Could not serialize the unsupported type " + component.getClass().getName());
    }

    private static void createRecipeFile(JsonObject json, String fileName) {
        fileName = fileName.replaceAll(":", "_");
        File directory = new File("recipes/" + Loader.instance().activeModContainer().getModId());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File output = new File(directory, fileName + ".json");
        try (FileWriter writer = new FileWriter(output);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final class ShapelessSerializer
    implements IRecipeSerializer {
        public static final ShapelessSerializer INSTANCE = new ShapelessSerializer();

        private ShapelessSerializer() {
        }

        @Override
        public JsonObject serialize(ItemStack result, Object ... components) {
            JsonObject json = new JsonObject();
            ArrayList<JsonObject> ingredients = new ArrayList<JsonObject>();
            boolean isOreDict = false;
            for (Object component : components) {
                if (component instanceof String) {
                    isOreDict = true;
                }
                ingredients.add(RecipeJsonHell.serializeComponent(component));
            }
            JsonArray ingredientArray = new JsonArray();
            ingredients.forEach(arg_0 -> ((JsonArray)ingredientArray).add(arg_0));
            json.add("ingredients", (JsonElement)ingredientArray);
            json.addProperty("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
            json.add("result", (JsonElement)RecipeJsonHell.serializeComponent(result));
            return json;
        }
    }

    public static final class ShapedSerializer
    implements IRecipeSerializer {
        public static final ShapedSerializer INSTANCE = new ShapedSerializer();

        private ShapedSerializer() {
        }

        @Override
        public JsonObject serialize(ItemStack result, Object ... components) {
            int i;
            JsonObject json = new JsonObject();
            ArrayList<String> pattern = new ArrayList<String>();
            HashMap<String, JsonObject> inputMap = new HashMap<String, JsonObject>();
            boolean isOreDict = false;
            Character curKey = null;
            for (i = 0; i < components.length && components[i] instanceof String; ++i) {
                pattern.add((String)components[i]);
            }
            while (i < components.length) {
                Object component = components[i];
                if (component instanceof Character) {
                    if (curKey != null) {
                        throw new IllegalArgumentException("Provided two char keys in a row");
                    }
                    curKey = (Character)component;
                } else {
                    if (curKey == null) {
                        throw new IllegalArgumentException("Providing object without a char key");
                    }
                    if (component instanceof String) {
                        isOreDict = true;
                    }
                    inputMap.put(Character.toString(curKey.charValue()), RecipeJsonHell.serializeComponent(component));
                    curKey = null;
                }
                ++i;
            }
            JsonArray patternArray = new JsonArray();
            pattern.forEach(arg_0 -> ((JsonArray)patternArray).add(arg_0));
            JsonObject inputKeys = new JsonObject();
            inputMap.forEach((arg_0, arg_1) -> ((JsonObject)inputKeys).add(arg_0, arg_1));
            json.addProperty("type", isOreDict ? "forge:ore_shaped" : "minecraft:crafting_shaped");
            json.add("pattern", (JsonElement)patternArray);
            json.add("key", (JsonElement)inputKeys);
            json.add("result", (JsonElement)RecipeJsonHell.serializeComponent(result));
            return json;
        }
    }
}

