/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.command.internal;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.lib.debug.DataDump;

public class CommandDataDump
extends CommandBase {
    public String func_71517_b() {
        return "silentlib_datadump";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"slib_dump");
    }

    public String func_71518_a(ICommandSender sender) {
        StringBuilder subcommands = new StringBuilder();
        for (SubCommand sub : SubCommand.values()) {
            if (subcommands.length() > 0) {
                subcommands.append("|");
            }
            subcommands.append(sub.func_176610_l());
        }
        return String.format("%sUsage: /%s <%s>", TextFormatting.RED, this.func_71517_b(), subcommands.toString());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        this.getSubCommand(args[0]).ifPresent(subCommand -> {
            subCommand.execute();
            String line = String.format("Printed %s list to log", subCommand.func_176610_l());
            sender.func_145747_a((ITextComponent)new TextComponentString(line));
        });
    }

    private Optional<SubCommand> getSubCommand(String arg) {
        for (SubCommand subCommand : SubCommand.values()) {
            if (!subCommand.name().equalsIgnoreCase(arg)) continue;
            return Optional.of(subCommand);
        }
        return Optional.empty();
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandDataDump.func_175762_a((String[])args, (Collection)((Collection)Arrays.stream(SubCommand.values()).map(SubCommand::func_176610_l).collect(ImmutableList.toImmutableList())));
        }
        return ImmutableList.of();
    }

    static enum SubCommand implements IStringSerializable
    {
        BLOCK(DataDump::dumpBlocks),
        ENCHANTMENT(DataDump::dumpEnchantments),
        ENTITY(DataDump::dumpEntityList),
        ITEM(DataDump::dumpItems),
        POTION(DataDump::dumpPotionEffects);

        private final Runnable command;

        private SubCommand(Runnable command) {
            this.command = command;
        }

        void execute() {
            this.command.run();
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

