/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jwaresoftware.mcmods.lib.Enchants;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.OwnerDef;
import org.jwaresoftware.mcmods.lib.Strings;
import org.lwjgl.input.Keyboard;

public final class Tooltips {
    private static final String _MISSING = "\\o/";
    private static final int _TOOWIDE = 200;
    static final AtomicBoolean _defaultFlag = new AtomicBoolean(false);
    static final ConcurrentMap<ModIntegration, Boolean> _hiddenFlags = new ConcurrentHashMap<ModIntegration, Boolean>();
    private static boolean _SIMPLE_FORM_SENTENCE = false;
    private static int _GRAY_LEN = 1;
    private static int _RESET_LEN = 1;

    private static boolean hideDocTooltips(ModIntegration modid) {
        return modid == null ? _defaultFlag.get() : _hiddenFlags.getOrDefault((Object)modid, false).booleanValue();
    }

    public static void setHidden(ModIntegration modid, boolean flag) {
        if (modid != null) {
            _hiddenFlags.put(modid, flag);
        } else {
            _defaultFlag.set(flag);
        }
    }

    public static void setHidden(boolean flag) {
        Tooltips.setHidden(null, flag);
    }

    public static final boolean hasUiTip(@Nonnull Block block) {
        String i18n_key = block.func_149739_a();
        String uitip = Strings.translateDefault("tooltip." + i18n_key, _MISSING);
        if (!_MISSING.equals(uitip)) {
            return true;
        }
        uitip = Strings.translateDefault("tooltip_summ." + i18n_key, _MISSING);
        return !_MISSING.equals(uitip);
    }

    @SideOnly(value=Side.CLIENT)
    private static void addWrapped(ItemStack stack, String displayName, String uitip, int maxlinewidth, List<String> tooltip) {
        FontRenderer fontRenderer = stack.func_77973_b().getFontRenderer(stack);
        if (fontRenderer == null) {
            fontRenderer = Minecraft.func_71410_x().field_71466_p;
        }
        int width = fontRenderer.func_78256_a(displayName);
        List lines = fontRenderer.func_78271_c(uitip, Math.max(width, maxlinewidth));
        ListIterator<String> litr = lines.listIterator();
        while (litr.hasNext()) {
            String line = (String)litr.next();
            litr.set("" + TextFormatting.GRAY + line + TextFormatting.RESET);
        }
        tooltip.addAll(lines);
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean addDocTipLine(ItemStack stack, List<String> tooltip, String tip_id_prefix) {
        boolean did = false;
        String uitip = Strings.translateDefault(tip_id_prefix + "." + stack.func_77973_b().func_77667_c(stack), _MISSING);
        if (!_MISSING.equals(uitip)) {
            tooltip.add("" + TextFormatting.GRAY + uitip + TextFormatting.RESET);
            did = true;
        }
        return did;
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean addDocTipLine(@Nonnull ModIntegration modid, ItemStack stack, List<String> tooltip, String tip_id_prefix) {
        if (Tooltips.hideDocTooltips(modid)) {
            return false;
        }
        return Tooltips.addDocTipLine(stack, tooltip, tip_id_prefix);
    }

    static final void initLanguageSupport() {
        Locale SPANISH = new Locale("es");
        String lang = Locale.getDefault().getLanguage();
        _SIMPLE_FORM_SENTENCE = lang.isEmpty() || lang.equals(Locale.ENGLISH.getLanguage()) || lang.equals(SPANISH.getLanguage()) || lang.equals(Locale.FRENCH.getLanguage()) || lang.equals(Locale.GERMAN.getLanguage());
        _GRAY_LEN = TextFormatting.GRAY.toString().length();
        _RESET_LEN = TextFormatting.RESET.toString().length();
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean addDocTip(ItemStack stack, List<String> tooltip, String tip_id_summ, String tip_id_full) {
        boolean want_full = Tooltips.wantsFullDescriptionTip();
        boolean has_full = tip_id_full != null && Strings.hasTranslation(tip_id_full);
        String tip_id = tip_id_summ;
        if (want_full && has_full) {
            tip_id = tip_id_full;
        }
        boolean did = false;
        String uitip = Strings.translateDefault(tip_id, _MISSING);
        if (!_MISSING.equals(uitip)) {
            String uitip_summ;
            if (uitip.startsWith("{SUMM}") && tip_id == tip_id_full && !_MISSING.equals(uitip_summ = Strings.translateDefault(tip_id_summ, _MISSING))) {
                uitip = uitip_summ + uitip.substring(6);
            }
            Tooltips.addWrapped(stack, tooltip.get(0), uitip, 200, tooltip);
            if (!want_full && has_full) {
                if (_SIMPLE_FORM_SENTENCE) {
                    StringBuilder ll = new StringBuilder(300);
                    String last = tooltip.get(tooltip.size() - 1);
                    ll.append(last.substring(_GRAY_LEN, last.length() - _RESET_LEN));
                    char ch = ll.charAt(ll.length() - 1);
                    if (ch != '.' && ch != '!' && Character.isLetterOrDigit(ch)) {
                        ll.append('.');
                    }
                    ll.append(" ").append(Strings.translateTooltip("full.description.howto"));
                    tooltip.remove(tooltip.size() - 1);
                    Tooltips.addWrapped(stack, tooltip.get(0), ll.toString(), 200, tooltip);
                } else {
                    tooltip.add(Strings.translateTooltip("full.description.howto"));
                }
            }
            if (Enchants.isEnchanted(stack, false)) {
                tooltip.add("");
            }
            did = true;
        }
        return did;
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean addDocTip(ModIntegration modid, ItemStack stack, List<String> tooltip, String tip_id_summ, String tip_id_full) {
        if (Tooltips.hideDocTooltips(modid)) {
            return false;
        }
        return Tooltips.addDocTip(stack, tooltip, tip_id_summ, tip_id_full);
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean addDocTipDefault(@Nonnull ItemStack stack, List<String> tooltip) {
        String i18n = stack.func_77973_b().func_77667_c(stack);
        return Tooltips.addDocTip(stack, tooltip, "tooltip_summ." + i18n, "tooltip_full." + i18n);
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean addDocTipDefault(ModIntegration modid, @Nonnull ItemStack stack, List<String> tooltip) {
        if (Tooltips.hideDocTooltips(modid)) {
            return false;
        }
        return Tooltips.addDocTipDefault(stack, tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean addDocTipSharedSummary(@Nonnull ItemStack stack, List<String> tooltip, String tip_id_summ) {
        String i18n = stack.func_77973_b().func_77667_c(stack);
        return Tooltips.addDocTip(stack, tooltip, tip_id_summ, "tooltip_full." + i18n);
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean addDocTipSharedSummary(ModIntegration modid, @Nonnull ItemStack stack, List<String> tooltip, String tip_id_summ) {
        if (Tooltips.hideDocTooltips(modid)) {
            return false;
        }
        return Tooltips.addDocTipSharedSummary(stack, tooltip, tip_id_summ);
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addHowToMoreItemDetailsTip(List<String> tooltip, boolean spacing) {
        if (spacing && !tooltip.isEmpty() && !tooltip.get(tooltip.size() - 1).isEmpty()) {
            tooltip.add("");
        }
        tooltip.add(Strings.translateTooltip("more.itemdetails.howto"));
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean extendI18nDocTip(String tip_id, ItemStack stack, List<String> tooltip) {
        boolean did = false;
        String uitip = Strings.translateDefault("" + tip_id + "." + stack.func_77973_b().func_77667_c(stack), _MISSING);
        if (!_MISSING.equals(uitip)) {
            uitip = "" + TextFormatting.GRAY + uitip + TextFormatting.RESET;
            if (tooltip.isEmpty()) {
                tooltip.add(uitip);
            } else if (tooltip.get(tooltip.size() - 1).isEmpty()) {
                tooltip.set(tooltip.size() - 1, uitip);
                tooltip.add("");
            } else {
                tooltip.add(tooltip.get(tooltip.size() - 1) + uitip);
            }
            did = true;
        }
        return did;
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean extendDocTip(@Nonnull ItemStack stack, List<String> tooltip, String uitip) {
        boolean shift = false;
        if (!tooltip.isEmpty() && tooltip.get(tooltip.size() - 1).isEmpty()) {
            tooltip.set(tooltip.size() - 1, uitip);
            tooltip.add("");
            shift = true;
        }
        if (!shift) {
            tooltip.add(uitip);
        }
        return shift;
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean addOwnerTip(@Nonnull ItemStack stack, List<String> tooltip) {
        boolean did = false;
        OwnerDef owner = Instructions.getOwnerDef(stack);
        if (owner != null) {
            String name = owner.name;
            if (name == null) {
                name = Strings.translate("entity.HIDDEN.name");
            }
            Tooltips.addTipLine(tooltip, Strings.tooltipKey("owner"), TextFormatting.GOLD, null, name);
            did = true;
        }
        return did;
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addTipLine(List<String> tooltip, String labelid, TextFormatting labelcolor, TextFormatting valuecolor, Object value) {
        if (valuecolor == null) {
            valuecolor = TextFormatting.GRAY;
        }
        String displayString = labelcolor == null ? Strings.translate(labelid) + value : "" + labelcolor + Strings.translate(labelid) + valuecolor + value;
        tooltip.add(displayString);
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addTipLine(List<String> tooltip, String labelid, TextFormatting labelcolor, Object line) {
        Tooltips.addTipLine(tooltip, labelid, labelcolor, null, line);
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean wantsFullDescriptionTip() {
        return Keyboard.isKeyDown((int)54);
    }

    @SideOnly(value=Side.CLIENT)
    public static final boolean wantsMoreItemDetailsTip(boolean advancedFlag) {
        return advancedFlag || Keyboard.isKeyDown((int)42);
    }

    @SideOnly(value=Side.CLIENT)
    public static final String getFullDescriptionLabel() {
        return Strings.translateTooltip("full.description.howto", "+RSHIFT for full description...");
    }

    @SideOnly(value=Side.CLIENT)
    public static final String getMoreItemDetailsLabel() {
        return Strings.translateTooltip("more.itemdetails.howto", "+LSHIFT for more details...");
    }

    @SideOnly(value=Side.CLIENT)
    public static final String getFullDescriptionKeyLabel() {
        return Strings.translateTooltip("key.RSHIFT", "+RSHIFT");
    }

    @SideOnly(value=Side.CLIENT)
    public static final String getMoreItemDetailsKeyLabel() {
        return Strings.translateTooltip("key.LSHIFT", "+LSHIFT");
    }

    @SideOnly(value=Side.CLIENT)
    public static final String getUseKeyLabel() {
        KeyBinding keyClickBinding = Minecraft.func_71410_x().field_71474_y.field_74313_G;
        return keyClickBinding.getDisplayName();
    }

    @SideOnly(value=Side.CLIENT)
    public static final String getSneakKeyLabel() {
        KeyBinding keyClickBinding = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        return keyClickBinding.getDisplayName();
    }

    private Tooltips() {
    }
}

