/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.client;

import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import knightminer.inspirations.tools.item.ItemWaypointCompass;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WaypointCompassGetter
implements IItemPropertyGetter {
    private Map<ItemStack, Wobble> wobbleMap = new WeakHashMap<ItemStack, Wobble>();

    @SideOnly(value=Side.CLIENT)
    public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entityIn) {
        EntityLivingBase entity;
        if (entityIn == null && !stack.func_82839_y()) {
            return 0.0f;
        }
        boolean isHeld = entityIn != null;
        Object object = entity = isHeld ? entityIn : stack.func_82836_z();
        if (world == null) {
            if (entity.field_70170_p == null) {
                return 0.0f;
            }
            world = entity.field_70170_p;
        }
        double angle = this.getAngle(stack, world, (Entity)entity, isHeld);
        if (entity == Minecraft.func_71410_x().field_71439_g) {
            angle = this.wobble(stack, world, angle);
        }
        return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private double getAngle(ItemStack stack, @Nullable World world, @Nullable Entity entity, boolean isHeld) {
        BlockPos pos;
        Integer dimension = ItemWaypointCompass.getDimension(stack);
        if (dimension != null && (pos = ItemWaypointCompass.getPos(stack, dimension, world.field_73011_w.getDimension())) != null) {
            double entityAngle = isHeld ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
            entityAngle = MathHelper.func_191273_b((double)(entityAngle / 360.0), (double)1.0);
            double posAngle = this.posToAngle(pos, entity) / (Math.PI * 2);
            return 0.5 - (entityAngle - 0.25 - posAngle);
        }
        return Math.random();
    }

    @SideOnly(value=Side.CLIENT)
    private double getFrameRotation(EntityItemFrame frame) {
        return MathHelper.func_188209_b((int)(180 + frame.field_174860_b.func_176736_b() * 90));
    }

    @SideOnly(value=Side.CLIENT)
    private double posToAngle(BlockPos pos, Entity entity) {
        return Math.atan2((double)pos.func_177952_p() + 0.5 - entity.field_70161_v, (double)pos.func_177958_n() + 0.5 - entity.field_70165_t);
    }

    @SideOnly(value=Side.CLIENT)
    private double wobble(ItemStack stack, World world, double angle) {
        Wobble wobble = this.wobbleMap.computeIfAbsent(stack, s -> new Wobble());
        if (world.func_82737_E() != wobble.lastUpdateTick) {
            wobble.lastUpdateTick = world.func_82737_E();
            double newAngle = angle - wobble.rotation;
            newAngle = MathHelper.func_191273_b((double)(newAngle + 0.5), (double)1.0) - 0.5;
            wobble.rota += newAngle * 0.1;
            wobble.rota *= 0.8;
            wobble.rotation = MathHelper.func_191273_b((double)(wobble.rotation + wobble.rota), (double)1.0);
        }
        return wobble.rotation;
    }

    private static class Wobble {
        double rotation;
        double rota;
        long lastUpdateTick;

        private Wobble() {
        }
    }
}

