/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools;

import knightminer.inspirations.common.ClientProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tools.client.RenderModArrow;
import knightminer.inspirations.tools.entity.EntityModArrow;
import knightminer.inspirations.tools.item.ItemModArrow;
import knightminer.inspirations.tools.item.ItemWaypointCompass;
import knightminer.inspirations.utility.block.BlockRedstoneCharge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ToolsClientProxy
extends ClientProxy {
    @Override
    public void preInit() {
        super.preInit();
        RenderingRegistry.registerEntityRenderingHandler(EntityModArrow.class, RenderModArrow::new);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        ToolsClientProxy.setModelStateMapper(InspirationsTools.redstoneCharge, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRedstoneCharge.FACING, BlockRedstoneCharge.QUICK}).func_178441_a());
        ToolsClientProxy.registerItemModel(InspirationsTools.redstoneCharger);
        ToolsClientProxy.registerItemModel(InspirationsTools.woodenCrook);
        ToolsClientProxy.registerItemModel(InspirationsTools.stoneCrook);
        ToolsClientProxy.registerItemModel(InspirationsTools.boneCrook);
        ToolsClientProxy.registerItemModel(InspirationsTools.blazeCrook);
        ToolsClientProxy.registerItemModel(InspirationsTools.witherCrook);
        ToolsClientProxy.registerItemModel(InspirationsTools.northCompass);
        ToolsClientProxy.registerItemModel(InspirationsTools.barometer);
        ToolsClientProxy.registerItemModel(InspirationsTools.photometer);
        ToolsClientProxy.registerItemModel(InspirationsTools.waypointCompass);
        for (ItemModArrow.ArrowType type : ItemModArrow.ArrowType.values()) {
            ToolsClientProxy.registerItemModel((Item)InspirationsTools.arrow, type.getMeta(), type.getName());
        }
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        ToolsClientProxy.registerItemColors(itemColors, (stack, tintIndex) -> {
            EnumDyeColor color = EnumDyeColor.func_176764_b((int)stack.func_77960_j());
            if (tintIndex == 0) {
                if (color == EnumDyeColor.BLACK) {
                    return 0x444444;
                }
                if (color == EnumDyeColor.WHITE) {
                    return 0xDDDDDD;
                }
                return color.field_193351_w;
            }
            if (tintIndex == 1) {
                return ItemWaypointCompass.getNeedleColor(color);
            }
            return -1;
        }, InspirationsTools.waypointCompass);
    }

    @SubscribeEvent
    public static void fixShieldTooltip(ItemTooltipEvent event) {
        if (!Config.fixShieldTooltip) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() != Items.field_185159_cQ) {
            return;
        }
        NBTTagCompound tags = stack.func_179543_a("BlockEntityTag");
        if (tags != null && tags.func_74764_b("Patterns") && stack.func_77948_v()) {
            NBTTagList patterns = tags.func_150295_c("Patterns", 10);
            event.getToolTip().add(patterns.func_74745_c() + 1, "");
        }
    }
}

