/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools;

import com.google.common.eventbus.Subscribe;
import knightminer.inspirations.common.CommonProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.shared.InspirationsShared;
import knightminer.inspirations.tools.ToolsEvents;
import knightminer.inspirations.tools.client.BarometerGetter;
import knightminer.inspirations.tools.client.NorthCompassGetter;
import knightminer.inspirations.tools.client.PhotometerGetter;
import knightminer.inspirations.tools.enchantment.EnchantmentAxeDamage;
import knightminer.inspirations.tools.enchantment.EnchantmentAxeLooting;
import knightminer.inspirations.tools.enchantment.EnchantmentExtendedFire;
import knightminer.inspirations.tools.enchantment.EnchantmentExtendedKnockback;
import knightminer.inspirations.tools.enchantment.EnchantmentShieldProtection;
import knightminer.inspirations.tools.enchantment.EnchantmentShieldThorns;
import knightminer.inspirations.tools.entity.EntityModArrow;
import knightminer.inspirations.tools.item.ItemCrook;
import knightminer.inspirations.tools.item.ItemEnchantableShield;
import knightminer.inspirations.tools.item.ItemModArrow;
import knightminer.inspirations.tools.item.ItemRedstoneCharger;
import knightminer.inspirations.tools.item.ItemWaypointCompass;
import knightminer.inspirations.tools.recipe.WaypointCompassCopyRecipe;
import knightminer.inspirations.utility.block.BlockRedstoneCharge;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Bootstrap;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="InspirationsTools", description="Adds various tools or tweaks to vanilla tools")
public class InspirationsTools
extends PulseBase {
    public static final String pulseID = "InspirationsTools";
    @SidedProxy(clientSide="knightminer.inspirations.tools.ToolsClientProxy", serverSide="knightminer.inspirations.common.CommonProxy")
    public static CommonProxy proxy;
    public static Item redstoneCharger;
    public static Item woodenCrook;
    public static Item stoneCrook;
    public static Item boneCrook;
    public static Item blazeCrook;
    public static Item witherCrook;
    public static Item northCompass;
    public static Item barometer;
    public static Item photometer;
    public static Item waypointCompass;
    public static Item.ToolMaterial bone;
    public static Item.ToolMaterial blaze;
    public static Item.ToolMaterial wither;
    public static Block redstoneCharge;
    public static ItemArrow arrow;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        if (Config.separateCrook) {
            bone = EnumHelper.addToolMaterial((String)Util.prefix("bone"), (int)1, (int)225, (float)4.0f, (float)1.5f, (int)10);
            if (Config.netherCrooks) {
                blaze = EnumHelper.addToolMaterial((String)Util.prefix("blaze"), (int)2, (int)300, (float)6.0f, (float)2.0f, (int)20);
                wither = EnumHelper.addToolMaterial((String)Util.prefix("wither"), (int)2, (int)375, (float)6.0f, (float)1.5f, (int)10);
            }
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        if (Config.enableRedstoneCharge || Config.enableChargedArrow) {
            redstoneCharge = InspirationsTools.registerBlock((IForgeRegistry<Block>)r, new BlockRedstoneCharge(), "redstone_charge");
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        arrow = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new ItemModArrow(), "arrow");
        if (Config.enableRedstoneCharge) {
            redstoneCharger = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new ItemRedstoneCharger(), "redstone_charger");
        }
        if (Config.separateCrook) {
            woodenCrook = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new ItemCrook(Item.ToolMaterial.WOOD), "wooden_crook");
            stoneCrook = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new ItemCrook(Item.ToolMaterial.STONE), "stone_crook");
            boneCrook = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new ItemCrook(bone), "bone_crook");
            if (Config.netherCrooks) {
                blazeCrook = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new ItemCrook(blaze), "blaze_crook");
                witherCrook = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new ItemCrook(wither), "wither_crook");
            }
        }
        if (Config.enableNorthCompass) {
            northCompass = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new Item().func_77637_a(CreativeTabs.field_78040_i), "north_compass");
            northCompass.func_185043_a(new ResourceLocation("angle"), (IItemPropertyGetter)new NorthCompassGetter());
            if (Config.renameVanillaCompass) {
                Items.field_151111_aL.func_77655_b(Util.prefix("origin_compass"));
            }
        }
        if (Config.enableBarometer) {
            barometer = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new Item().func_77637_a(CreativeTabs.field_78040_i), "barometer");
            barometer.func_185043_a(new ResourceLocation("height"), (IItemPropertyGetter)new BarometerGetter());
        }
        if (Config.enablePhotometer) {
            photometer = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new Item().func_77637_a(CreativeTabs.field_78040_i), "photometer");
            photometer.func_185043_a(new ResourceLocation("light"), (IItemPropertyGetter)new PhotometerGetter());
        }
        if (Config.enableWaypointCompass) {
            waypointCompass = InspirationsTools.registerItem((IForgeRegistry<Item>)r, new ItemWaypointCompass(), "waypoint_compass");
        }
        if (Config.shieldEnchantmentTable) {
            InspirationsTools.register(r, new ItemEnchantableShield(), new ResourceLocation("shield"));
        }
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry r = event.getRegistry();
        r.register((IForgeRegistryEntry)InspirationsTools.getEntityBuilder(EntityModArrow.class, "arrow", 0).tracker(64, 1, false).build());
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        if (Config.copyWaypointCompass) {
            InspirationsTools.register(r, new WaypointCompassCopyRecipe(), "waypoint_compass_copy");
        }
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        EntityEquipmentSlot[] slots;
        IForgeRegistry r = event.getRegistry();
        if (Config.moreShieldEnchantments) {
            slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
            InspirationsTools.register(r, new EnchantmentShieldProtection(Enchantment.Rarity.COMMON, EnchantmentProtection.Type.ALL, slots), new ResourceLocation("protection"));
            InspirationsTools.register(r, new EnchantmentShieldProtection(Enchantment.Rarity.UNCOMMON, EnchantmentProtection.Type.FIRE, slots), new ResourceLocation("fire_protection"));
            InspirationsTools.register(r, new EnchantmentShieldProtection(Enchantment.Rarity.UNCOMMON, EnchantmentProtection.Type.PROJECTILE, slots), new ResourceLocation("projectile_protection"));
            InspirationsTools.register(r, new EnchantmentShieldProtection(Enchantment.Rarity.RARE, EnchantmentProtection.Type.EXPLOSION, slots), new ResourceLocation("blast_protection"));
            InspirationsTools.register(r, new EnchantmentShieldThorns(Enchantment.Rarity.VERY_RARE, slots), new ResourceLocation("thorns"));
        }
        if (Config.moreShieldEnchantments || Config.axeWeaponEnchants) {
            slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND};
            InspirationsTools.register(r, new EnchantmentExtendedKnockback(Enchantment.Rarity.UNCOMMON, slots), new ResourceLocation("knockback"));
            InspirationsTools.register(r, new EnchantmentExtendedFire(Enchantment.Rarity.RARE, slots), new ResourceLocation("fire_aspect"));
            if (Config.axeWeaponEnchants) {
                InspirationsTools.register(r, new EnchantmentAxeLooting(Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, slots), new ResourceLocation("looting"));
            }
        }
        if (Config.axeEnchantmentTable) {
            slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND};
            InspirationsTools.register(r, new EnchantmentAxeDamage(Enchantment.Rarity.COMMON, 0, slots), new ResourceLocation("sharpness"));
            InspirationsTools.register(r, new EnchantmentAxeDamage(Enchantment.Rarity.UNCOMMON, 1, slots), new ResourceLocation("smite"));
            InspirationsTools.register(r, new EnchantmentAxeDamage(Enchantment.Rarity.UNCOMMON, 2, slots), new ResourceLocation("bane_of_arthropods"));
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        if (Config.separateCrook) {
            bone.setRepairItem(new ItemStack(Items.field_151103_aS));
            if (Config.netherCrooks) {
                blaze.setRepairItem(new ItemStack(Items.field_151072_bj));
                wither.setRepairItem(InspirationsShared.witherBone);
            }
        }
        this.registerDispenserBehavior();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        MinecraftForge.EVENT_BUS.register(ToolsEvents.class);
    }

    private void registerDispenserBehavior() {
        InspirationsTools.registerDispenserBehavior((Item)arrow, (IBehaviorDispenseItem)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World world, IPosition position, ItemStack stack) {
                EntityModArrow arrow = new EntityModArrow(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), stack.func_77960_j());
                arrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return arrow;
            }
        });
        InspirationsTools.registerDispenserBehavior(redstoneCharger, (IBehaviorDispenseItem)new Bootstrap.BehaviorDispenseOptional(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                this.field_190911_b = true;
                World world = source.func_82618_k();
                EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                BlockPos pos = source.func_180699_d().func_177972_a(facing);
                if (redstoneCharge.func_176196_c(world, pos)) {
                    world.func_175656_a(pos, redstoneCharge.func_176223_P().func_177226_a((IProperty)BlockRedstoneCharge.FACING, (Comparable)facing));
                    if (stack.func_96631_a(1, world.field_73012_v, null)) {
                        stack.func_190920_e(0);
                    }
                } else {
                    this.field_190911_b = false;
                }
                return stack;
            }
        });
    }
}

