/*
 * Decompiled with CFR 0.152.
 */
package vazkii.potionfingers;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.item.ItemMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.potionfingers.PotionFingers;

public class ItemRing
extends ItemMod
implements IBauble,
IItemColorProvider {
    private static final String TAG_POTION_EFFECT = "effect";
    private static final String[] VARIANTS = new String[]{"ring_disabled", "ring_enabled"};
    public static final int EFFECT_DURATION = 199;
    public static final int EFFECT_REFRESH_RATE = 99;

    public ItemRing() {
        super("ring", VARIANTS);
        this.func_77637_a(CreativeTabs.field_78038_k);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public String getModNamespace() {
        return "potionfingers";
    }

    public String getUniqueModel() {
        return "ring";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (tab == this.func_77640_w()) {
            subItems.add((Object)new ItemStack((Item)this));
            for (Potion p : PotionFingers.DEFAULT_EFFECTS) {
                subItems.add((Object)ItemRing.getRingForPotion(p));
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemRing.getPotion(stack) != null;
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        Potion p = ItemRing.getPotion(stack);
        String potionName = "N/A";
        if (p != null) {
            potionName = I18n.func_74838_a((String)p.func_76393_a());
        }
        return String.format(name, potionName);
    }

    public static ItemStack getRingForPotion(Potion potion) {
        String id = potion.getRegistryName().toString();
        ItemStack stack = new ItemStack(PotionFingers.ring, 1, 1);
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_POTION_EFFECT, (String)id);
        return stack;
    }

    public static Potion getPotion(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        String effect = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_POTION_EFFECT, (String)"");
        if (effect.isEmpty()) {
            return null;
        }
        return (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(effect));
    }

    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, i) -> {
            Potion p;
            if (i != 0 && (p = ItemRing.getPotion(stack)) != null) {
                return p.func_76401_j();
            }
            return 0xFFFFFF;
        };
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        this.updatePotionStatus(player, ItemRing.getPotion(itemstack), itemstack, false);
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        this.updatePotionStatus(player, ItemRing.getPotion(itemstack), itemstack, true);
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        Potion potion = ItemRing.getPotion(itemstack);
        if (!(potion == null || player.field_70173_aa % 99 != 0 && player.func_70644_a(potion))) {
            this.updatePotionStatus(player, potion, itemstack, false);
        }
    }

    public void updatePotionStatus(EntityLivingBase player, Potion potion, ItemStack ring, boolean unequipping) {
        PotionEffect currentEffect;
        int currentLevel;
        if (potion == null || player.field_70170_p.field_72995_K || !(player instanceof EntityPlayer)) {
            return;
        }
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)player));
        int level = -1;
        for (int slot : BaubleType.RING.getValidSlots()) {
            Potion potion1;
            ItemStack ring1 = inv.getStackInSlot(slot);
            Object object = potion1 = unequipping && ring == ring1 ? null : ItemRing.getPotion(ring1);
            if (potion1 != potion) continue;
            ++level;
        }
        if (level > 1) {
            level = 1;
        }
        int n = currentLevel = (currentEffect = player.func_70660_b(potion)) != null ? currentEffect.func_76458_c() : -1;
        assert (currentLevel <= level || currentEffect != null);
        if (unequipping && currentLevel > level && currentEffect.func_76459_b() <= 199) {
            player.func_184589_d(potion);
        }
        if (level != -1) {
            player.func_70690_d(new PotionEffect(potion, 199, level, true, false));
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }
}

