/*
 * Decompiled with CFR 0.152.
 */
package com.chaosbuffalo.spartanfire.recipes;

import com.github.alexthe666.iceandfire.core.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FireIceThrowingRecipes
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static final Map<Item, Item> weaponMapFire;
    private static final Map<Item, Item> weaponMapIce;

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.validInput(inv) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        Integer[] slots = this.validInput(inv);
        if (slots == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInput = inv.func_70301_a(slots[1].intValue());
        ItemStack output = inv.func_70301_a(slots[0].intValue()).func_77973_b() == ModItems.fire_dragon_blood ? new ItemStack(weaponMapFire.get(stackInput.func_77973_b())) : new ItemStack(weaponMapIce.get(stackInput.func_77973_b()));
        return output;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nullable
    private Integer[] validInput(InventoryCrafting inv) {
        int numStacks = 0;
        int bloodSlot = -1;
        int weaponSlot = -1;
        ArrayList<Integer> occupiedSlots = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            ++numStacks;
            occupiedSlots.add(i);
        }
        if (numStacks != 2) {
            return null;
        }
        Iterator i = occupiedSlots.iterator();
        while (i.hasNext()) {
            int i2 = (Integer)i.next();
            ItemStack itemStack = inv.func_70301_a(i2);
            if (itemStack.func_77973_b() == ModItems.fire_dragon_blood || itemStack.func_77973_b() == ModItems.ice_dragon_blood) {
                bloodSlot = i2;
                continue;
            }
            if (weaponMapFire.containsKey(itemStack.func_77973_b()) && !itemStack.func_77951_h()) {
                NBTTagCompound compound = itemStack.func_77978_p();
                if (compound == null || compound.func_74771_c("Original") != 1) {
                    return null;
                }
                weaponSlot = i2;
                continue;
            }
            return null;
        }
        Integer[] slots = new Integer[]{bloodSlot, weaponSlot};
        return bloodSlot != -1 && weaponSlot != -1 ? slots : null;
    }

    static {
        HashMap<Item, Item> tempFireMap = new HashMap<Item, Item>();
        HashMap<Item, Item> tempIceMap = new HashMap<Item, Item>();
        tempFireMap.put(Item.func_111206_d((String)"spartanfire:throwing_axe_dragonbone"), Item.func_111206_d((String)"spartanfire:throwing_axe_fire_dragonbone"));
        tempFireMap.put(Item.func_111206_d((String)"spartanfire:throwing_knife_dragonbone"), Item.func_111206_d((String)"spartanfire:throwing_knife_fire_dragonbone"));
        tempFireMap.put(Item.func_111206_d((String)"spartanfire:javelin_dragonbone"), Item.func_111206_d((String)"spartanfire:javelin_fire_dragonbone"));
        tempFireMap.put(Item.func_111206_d((String)"spartanfire:boomerang_dragonbone"), Item.func_111206_d((String)"spartanfire:boomerang_fire_dragonbone"));
        tempIceMap.put(Item.func_111206_d((String)"spartanfire:throwing_axe_dragonbone"), Item.func_111206_d((String)"spartanfire:throwing_axe_ice_dragonbone"));
        tempIceMap.put(Item.func_111206_d((String)"spartanfire:throwing_knife_dragonbone"), Item.func_111206_d((String)"spartanfire:throwing_knife_ice_dragonbone"));
        tempIceMap.put(Item.func_111206_d((String)"spartanfire:javelin_dragonbone"), Item.func_111206_d((String)"spartanfire:javelin_ice_dragonbone"));
        tempIceMap.put(Item.func_111206_d((String)"spartanfire:boomerang_dragonbone"), Item.func_111206_d((String)"spartanfire:boomerang_ice_dragonbone"));
        weaponMapFire = Collections.unmodifiableMap(tempFireMap);
        weaponMapIce = Collections.unmodifiableMap(tempIceMap);
    }
}

