/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.toast;

import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.api.toast.AbstractToast;
import codersafterdark.reskillable.client.base.RenderHelper;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class SkillToast
extends AbstractToast {
    private final Skill skill;
    private final int rank;

    public SkillToast(Skill skill, int level) {
        super(skill.getName(), new TextComponentTranslation("reskillable.toast.skill_desc", new Object[]{level}).func_150261_e());
        this.skill = skill;
        this.rank = this.skill.getRank(level);
    }

    @Override
    protected void renderImage(GuiToast guiToast) {
        if (this.skill.hasCustomSprites()) {
            ResourceLocation sprite = this.skill.getSpriteLocation(this.rank);
            if (sprite != null) {
                this.bindImage(guiToast, sprite);
                Gui.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            }
        } else {
            this.bindImage(guiToast, this.skill.getSpriteLocation());
            Pair<Integer, Integer> pair = this.skill.getSpriteFromRank(this.rank);
            RenderHelper.drawTexturedModalRect(this.x, this.y, 1.0f, (Integer)pair.getKey(), (Integer)pair.getValue(), 16, 16, 0.015625f, 0.015625f);
        }
    }

    @Override
    protected boolean hasImage() {
        return !this.skill.hasCustomSprites() || this.skill.getSpriteLocation(this.rank) != null;
    }
}

