/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common.bonusrequirements.setrequirement;

import com.fantasticsource.mctools.items.ItemFilter;
import com.fantasticsource.setbonus.common.bonusrequirements.setrequirement.SlotData;
import com.fantasticsource.tools.datastructures.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;

public class Set {
    public String parsedString;
    public String id;
    public String name;
    public LinkedHashMap<String, ItemFilter> involvedEquips = new LinkedHashMap();
    private ArrayList<SlotData> slotData = new ArrayList();
    private LinkedHashMap<EntityPlayer, Pair<Integer, Long>> numEquipped = new LinkedHashMap();

    private Set() {
    }

    public static Set getInstance(String parsableSet, Side side) {
        Set result = new Set();
        String[] tokens = parsableSet.split(",");
        if (tokens.length < 3) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.notEnoughSetArgs", (Object[])new Object[]{parsableSet}));
            return null;
        }
        result.id = tokens[0].trim();
        if (result.id.equals("")) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.noSetID", (Object[])new Object[]{parsableSet}));
            return null;
        }
        result.name = tokens[1].trim();
        for (String string : Arrays.copyOfRange(tokens, 2, tokens.length)) {
            SlotData data = SlotData.getInstance(string, result.involvedEquips, side);
            if (data == null) {
                return null;
            }
            result.slotData.add(data);
        }
        if (result.slotData.size() == 0) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.noSetReqs", (Object[])new Object[]{parsableSet}));
            return null;
        }
        result.parsedString = parsableSet;
        return result;
    }

    public int getNumberEquipped(EntityPlayer player) {
        long tick = player.field_70170_p.func_82737_E();
        Pair pair = this.numEquipped.computeIfAbsent(player, k -> new Pair((Object)0, (Object)(tick - 1L)));
        if ((Long)pair.getValue() != tick) {
            int result = this.getNumberEquippedInternal(player);
            pair.set((Object)result, (Object)tick);
            return result;
        }
        return (Integer)pair.getKey();
    }

    private int getNumberEquippedInternal(EntityPlayer player) {
        int result = 0;
        ArrayList<Integer> blocked = new ArrayList<Integer>();
        for (SlotData data : this.slotData) {
            int slot = data.equipped(player, blocked);
            if (slot == Integer.MIN_VALUE) continue;
            blocked.add(slot);
            ++result;
        }
        return result;
    }

    public int getMaxNumber() {
        return this.slotData.size();
    }
}

