/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.capability;

import cursedflames.bountifulbaubles.wormhole.DebugTarget;
import cursedflames.bountifulbaubles.wormhole.IWormholeTarget;
import cursedflames.bountifulbaubles.wormhole.PlayerTarget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityWormholePins {
    @CapabilityInject(value=IWormholePins.class)
    public static final Capability<IWormholePins> PIN_CAP = null;

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IWormholePins.class, (Capability.IStorage)new Storage(), DefaultImpl::new);
    }

    @SubscribeEvent
    public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(new ResourceLocation("bountifulbaubles", "IWormholePins"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
            IWormholePins inst = (IWormholePins)PIN_CAP.getDefaultInstance();

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == PIN_CAP;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(capability == PIN_CAP ? PIN_CAP.cast((Object)this.inst) : null);
            }

            public NBTTagCompound serializeNBT() {
                return (NBTTagCompound)PIN_CAP.getStorage().writeNBT(PIN_CAP, (Object)this.inst, null);
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                PIN_CAP.getStorage().readNBT(PIN_CAP, (Object)this.inst, null, (NBTBase)nbt);
            }
        });
    }

    public static NBTTagCompound targetListToNBT(List<IWormholeTarget> targets) {
        NBTTagCompound tag = new NBTTagCompound();
        int i = 0;
        for (IWormholeTarget target : targets) {
            NBTTagCompound targetNBT = target.toNBT();
            if (targetNBT == null) continue;
            tag.func_74782_a(String.valueOf(i++), (NBTBase)targetNBT);
        }
        return tag;
    }

    public static List<IWormholeTarget> targetListFromNBT(List<IWormholeTarget> targets, NBTTagCompound tag) {
        targets.clear();
        int i = 0;
        while (tag.func_74764_b(String.valueOf(i))) {
            NBTTagCompound entry = tag.func_74775_l(String.valueOf(i));
            IWormholeTarget target = CapabilityWormholePins.targetFromNBT(entry);
            if (target != null) {
                targets.add(target);
            }
            ++i;
        }
        return targets;
    }

    public static IWormholeTarget targetFromNBT(NBTTagCompound tag) {
        String type = tag.func_74779_i("type");
        IWormholeTarget target = null;
        if (type.equals("player")) {
            target = new PlayerTarget();
        } else if (type.equals("debug")) {
            target = new DebugTarget();
        }
        if (target == null) {
            return null;
        }
        target.fromNBT(tag);
        target.setEnabled(tag.func_74764_b("enabled") ? tag.func_74767_n("enabled") : true);
        return target;
    }

    public static class DefaultImpl
    implements IWormholePins {
        List<IWormholeTarget> pinList = new ArrayList<IWormholeTarget>();

        @Override
        public List<IWormholeTarget> getPinList() {
            return this.pinList;
        }
    }

    public static class Storage
    implements Capability.IStorage<IWormholePins> {
        public NBTBase writeNBT(Capability<IWormholePins> capability, IWormholePins instance, EnumFacing side) {
            List<IWormholeTarget> pins = instance.getPinList();
            return CapabilityWormholePins.targetListToNBT(pins);
        }

        public void readNBT(Capability<IWormholePins> capability, IWormholePins instance, EnumFacing side, NBTBase nbtBase) {
            if (!(nbtBase instanceof NBTTagCompound)) {
                return;
            }
            CapabilityWormholePins.targetListFromNBT(instance.getPinList(), (NBTTagCompound)nbtBase);
        }
    }

    public static interface IWormholePins {
        public List<IWormholeTarget> getPinList();
    }
}

