/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.block;

import baubles.api.cap.BaublesCapabilities;
import cursedflames.bountifulbaubles.ModConfig;
import cursedflames.bountifulbaubles.baubleeffect.EnumBaubleModifier;
import cursedflames.bountifulbaubles.block.GenericTileEntity;
import cursedflames.bountifulbaubles.util.XpUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileReforger
extends GenericTileEntity {
    private ItemStackHandler stackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            NBTTagCompound tag;
            TileReforger.this.func_70296_d();
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!(tag = stack.func_77978_p()).func_74764_b("baubleModifier")) {
                EnumBaubleModifier.generateModifier(stack);
            }
            if (!tag.func_74764_b("reforgeCost")) {
                tag.func_74768_a("reforgeCost", TileReforger.this.getReforgeCost(((TileReforger)TileReforger.this).field_145850_b.field_73012_v));
            }
        }
    };

    @Override
    public NBTTagCompound writeDataToNBT(NBTTagCompound tag) {
        tag.func_74782_a("items", (NBTBase)this.stackHandler.serializeNBT());
        return tag;
    }

    @Override
    public void readDataFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("items")) {
            this.stackHandler.deserializeNBT((NBTTagCompound)tag.func_74781_a("items"));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.stackHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound getBlockBreakNBT() {
        return null;
    }

    @Override
    public void loadBlockPlaceNBT(NBTTagCompound tag) {
    }

    public void tryReforge(EntityPlayer player) {
        ItemStack stack = this.stackHandler.getStackInSlot(0);
        if (stack.func_190926_b() || !stack.hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            return;
        }
        int xp = XpUtil.getPlayerXP(player);
        NBTTagCompound tag = stack.func_77978_p();
        int xpCost = -1;
        if (tag.func_74764_b("reforgeCost")) {
            xpCost = tag.func_74762_e("reforgeCost");
        }
        boolean creative = player.func_184812_l_();
        if ((xp >= xpCost || creative) && xpCost != -1) {
            if (!creative) {
                XpUtil.addPlayerXP(player, -xpCost);
            }
            EnumBaubleModifier.generateModifier(stack);
            tag.func_74768_a("reforgeCost", this.getReforgeCost(this.field_145850_b.field_73012_v));
            float vol = (float)(Math.random() * 0.3 + 0.9);
            float pitch = (float)(Math.random() * 0.3 + 0.85);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187698_i, SoundCategory.BLOCKS, vol, pitch);
        }
    }

    private int getReforgeCost(Random rand) {
        int max;
        int min = ModConfig.reforgeCostMin.getInt(80);
        if (min > (max = ModConfig.reforgeCostMax.getInt(320))) {
            int min_ = min;
            min = max;
            max = min_;
        }
        return this.field_145850_b.field_73012_v.nextInt(max - min + 1) + min;
    }
}

