/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.minecraft.util.ResourceLocation;

public class ClassResourceLocationMap<K, V> {
    private final Map<String, V> namespace2valueMap = new HashMap<String, V>();
    private final Map<String, V> resourceLocation2valueMap = new HashMap<String, V>();
    private final Map<Class<? extends K>, V> class2valueMap = new HashMap<Class<? extends K>, V>();
    private final Function<Class<K>, ResourceLocation> resourceLocationFunc;
    private final V defaultValue;
    private final Function<String[], V> valueParser;

    public ClassResourceLocationMap(Function<Class<K>, ResourceLocation> func, V defaultValue, Function<String[], V> valueParser) {
        this.resourceLocationFunc = func;
        this.defaultValue = defaultValue;
        this.valueParser = valueParser;
    }

    public V get(K t) {
        if (this.namespace2valueMap.isEmpty() && this.resourceLocation2valueMap.isEmpty()) {
            return this.defaultValue;
        }
        return (V)this.class2valueMap.computeIfAbsent(t.getClass(), k -> {
            ResourceLocation resourceLocation = this.resourceLocationFunc.apply((Class<K>)k);
            if (resourceLocation == null) {
                return this.defaultValue;
            }
            V value = this.resourceLocation2valueMap.get(resourceLocation.toString());
            if (value != null) {
                return value;
            }
            value = this.namespace2valueMap.get(resourceLocation.func_110624_b());
            if (value != null) {
                return value;
            }
            return this.defaultValue;
        });
    }

    public void load(String[] data) {
        this.namespace2valueMap.clear();
        this.resourceLocation2valueMap.clear();
        this.class2valueMap.clear();
        for (String entry : data) {
            int indexKeyDelimiter = entry.indexOf(58);
            int indexEntryDelimiter = entry.indexOf(61);
            String key = indexEntryDelimiter != -1 ? entry.substring(0, indexEntryDelimiter) : entry;
            String[] rawValue = indexEntryDelimiter != -1 ? (String[])Arrays.stream(entry.substring(indexEntryDelimiter + 1).split(",")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new) : new String[]{};
            V value = this.valueParser.apply(rawValue);
            if (value == null) continue;
            if (indexKeyDelimiter == -1 || indexEntryDelimiter != -1 && indexKeyDelimiter > indexEntryDelimiter) {
                this.namespace2valueMap.put(key, value);
                continue;
            }
            this.resourceLocation2valueMap.put(key, value);
        }
    }

    public static class Builder<A> {
        private final List<BiConsumer<A, String[]>> valueParsers = new ArrayList<BiConsumer<A, String[]>>();
        private int index;

        public <T> Builder<A> requiredValue(Function<String, T> parser, BiConsumer<A, T> accumulator) {
            int i = this.index++;
            this.valueParsers.add((v, s) -> accumulator.accept(v, parser.apply(s[i])));
            return this;
        }

        public <T> Builder<A> optionalValue(Function<String, T> parser, BiConsumer<A, T> accumulator, T defaultValue) {
            int i = this.index++;
            this.valueParsers.add((v, s) -> {
                Object t = null;
                try {
                    t = parser.apply(s[i]);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (t == null) {
                    t = defaultValue;
                }
                accumulator.accept(v, t);
            });
            return this;
        }

        public <K> ClassResourceLocationMap<K, A> build(Function<Class<K>, ResourceLocation> resourceLocationParser, A defaultValue, Supplier<A> supplier) {
            return this.build(resourceLocationParser, defaultValue, supplier, Function.identity());
        }

        public <K, V> ClassResourceLocationMap<K, V> build(Function<Class<K>, ResourceLocation> resourceLocationParser, V defaultValue, final Supplier<A> supplier, Function<A, V> finisher) {
            return new ClassResourceLocationMap<K, Object>(resourceLocationParser, defaultValue, s -> {
                try {
                    return this.valueParsers.stream().collect(new Collector<BiConsumer<A, String[]>, A, V>((String[])s, finisher){
                        final /* synthetic */ String[] val$s;
                        final /* synthetic */ Function val$finisher;
                        {
                            this.val$s = stringArray;
                            this.val$finisher = function;
                        }

                        @Override
                        public Supplier<A> supplier() {
                            return supplier;
                        }

                        @Override
                        public BiConsumer<A, BiConsumer<A, String[]>> accumulator() {
                            return (a, p) -> p.accept(a, this.val$s);
                        }

                        @Override
                        public BinaryOperator<A> combiner() {
                            return null;
                        }

                        @Override
                        public Function<A, V> finisher() {
                            return this.val$finisher;
                        }

                        @Override
                        public Set<Collector.Characteristics> characteristics() {
                            return Collections.emptySet();
                        }
                    });
                }
                catch (Exception e) {
                    return null;
                }
            });
        }
    }
}

