/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.reflect;

import com.charles445.rltweaker.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SereneSeasonsReflect {
    public final Class c_SeasonHelper = Class.forName("sereneseasons.api.season.SeasonHelper");
    public final Method m_SeasonHelper_getSeasonState = this.c_SeasonHelper.getDeclaredMethod("getSeasonState", World.class);
    public final Class c_ISeasonState = Class.forName("sereneseasons.api.season.ISeasonState");
    public final Method m_ISeasonState_getSubSeason = this.c_ISeasonState.getDeclaredMethod("getSubSeason", new Class[0]);
    public final Class c_Season$SubSeason = Class.forName("sereneseasons.api.season.Season$SubSeason");
    public final Class c_ModConfig = Class.forName("sereneseasons.init.ModConfig");
    public final Field f_ModConfig_seasons = ReflectUtil.findField(this.c_ModConfig, "seasons");
    public final Class c_SeasonsConfig = Class.forName("sereneseasons.config.SeasonsConfig");
    public final Method m_SeasonsConfig_isDimensionWhitelisted = ReflectUtil.findMethod(this.c_SeasonsConfig, "isDimensionWhitelisted");
    public final Field f_SeasonsConfig_generateSnowAndIce = ReflectUtil.findField(this.c_SeasonsConfig, "generateSnowAndIce");
    public final Field f_SeasonsConfig_changeWeatherFrequency = ReflectUtil.findField(this.c_SeasonsConfig, "changeWeatherFrequency");
    public final Class c_BiomeConfig = Class.forName("sereneseasons.config.BiomeConfig");
    public final Field f_BiomeConfig_biomeDataMap = ReflectUtil.findField(this.c_BiomeConfig, "biomeDataMap");
    public final Class c_BiomeData = Class.forName("sereneseasons.config.json.BiomeData");
    public final Field f_BiomeData_enableSeasonalEffects = ReflectUtil.findField(this.c_BiomeData, "enableSeasonalEffects");
    public final Field f_BiomeData_useTropicalSeasons = ReflectUtil.findField(this.c_BiomeData, "useTropicalSeasons");
    public final Method m_BlockIce_turnIntoWater = ReflectUtil.findMethodAny(BlockIce.class, "func_185679_b", "turnIntoWater", World.class, BlockPos.class);

    public Object getISeasonState(World world) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.m_SeasonHelper_getSeasonState.invoke(null, world);
    }

    public Object getSeasonConfig() throws IllegalArgumentException, IllegalAccessException {
        return this.f_ModConfig_seasons.get(null);
    }

    public boolean getConfigGenerateSnowAndIce(Object config) throws IllegalArgumentException, IllegalAccessException {
        return this.f_SeasonsConfig_generateSnowAndIce.getBoolean(config);
    }

    public boolean getConfigChangeWeatherFrequency(Object config) throws IllegalArgumentException, IllegalAccessException {
        return this.f_SeasonsConfig_changeWeatherFrequency.getBoolean(config);
    }

    public boolean isDimensionWhitelisted(int dimension) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Boolean)this.m_SeasonsConfig_isDimensionWhitelisted.invoke(null, dimension);
    }

    public Map<ResourceLocation, Object> getBiomeDataMap() throws IllegalArgumentException, IllegalAccessException {
        return (Map)this.f_BiomeConfig_biomeDataMap.get(null);
    }

    public Map<ResourceLocation, Boolean> createBiomeSeasonalEffects() throws IllegalArgumentException, IllegalAccessException {
        ConcurrentHashMap<ResourceLocation, Boolean> result = new ConcurrentHashMap<ResourceLocation, Boolean>();
        for (Map.Entry<ResourceLocation, Object> entry : this.getBiomeDataMap().entrySet()) {
            result.put(entry.getKey(), (boolean)((Boolean)this.f_BiomeData_enableSeasonalEffects.get(entry.getValue())));
        }
        return result;
    }

    public Map<ResourceLocation, Boolean> createBiomeTropicalSeasons() throws IllegalArgumentException, IllegalAccessException {
        ConcurrentHashMap<ResourceLocation, Boolean> result = new ConcurrentHashMap<ResourceLocation, Boolean>();
        for (Map.Entry<ResourceLocation, Object> entry : this.getBiomeDataMap().entrySet()) {
            result.put(entry.getKey(), (boolean)((Boolean)this.f_BiomeData_useTropicalSeasons.get(entry.getValue())));
        }
        return result;
    }

    public void turnIntoWater(Block blockIce, World world, BlockPos pos) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.m_BlockIce_turnIntoWater.invoke((Object)blockIce, world, pos);
    }

    public SubSeason getSubSeason(Object iSeasonState) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        switch (((Enum)this.m_ISeasonState_getSubSeason.invoke(iSeasonState, new Object[0])).name()) {
            case "EARLY_AUTUMN": {
                return SubSeason.EARLY_AUTUMN;
            }
            case "EARLY_SPRING": {
                return SubSeason.EARLY_SPRING;
            }
            case "EARLY_SUMMER": {
                return SubSeason.EARLY_SUMMER;
            }
            case "EARLY_WINTER": {
                return SubSeason.EARLY_WINTER;
            }
            case "LATE_AUTUMN": {
                return SubSeason.LATE_AUTUMN;
            }
            case "LATE_SPRING": {
                return SubSeason.LATE_SPRING;
            }
            case "LATE_SUMMER": {
                return SubSeason.LATE_SUMMER;
            }
            case "LATE_WINTER": {
                return SubSeason.LATE_WINTER;
            }
            case "MID_AUTUMN": {
                return SubSeason.MID_AUTUMN;
            }
            case "MID_SPRING": {
                return SubSeason.MID_SPRING;
            }
            case "MID_SUMMER": {
                return SubSeason.MID_SUMMER;
            }
            case "MID_WINTER": {
                return SubSeason.MID_WINTER;
            }
        }
        return null;
    }

    public static enum Season {
        WINTER,
        SPRING,
        SUMMER,
        AUTUMN;

    }

    public static enum SubSeason {
        EARLY_AUTUMN(Season.AUTUMN),
        EARLY_SPRING(Season.SPRING),
        EARLY_SUMMER(Season.SUMMER),
        EARLY_WINTER(Season.WINTER),
        LATE_AUTUMN(Season.AUTUMN),
        LATE_SPRING(Season.SPRING),
        LATE_SUMMER(Season.SUMMER),
        LATE_WINTER(Season.WINTER),
        MID_AUTUMN(Season.AUTUMN),
        MID_SPRING(Season.SPRING),
        MID_SUMMER(Season.SUMMER),
        MID_WINTER(Season.WINTER);

        private Season season;

        private SubSeason(Season season) {
            this.season = season;
        }

        public Season getSeason() {
            return this.season;
        }
    }
}

