/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.hook;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.util.CollisionUtil;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.WorldRadiusUtil;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class HookWorld {
    public static boolean warnItemHook = false;
    public static boolean warnSearchHook = false;
    public static boolean chunkTickPatchEnabled = false;
    public static IChunkTickPost sereneSeasonsPost = null;

    public static List<Entity> getEntitiesWithinAABBExcludingEntity(World world, @Nullable Entity entity, AxisAlignedBB bb) {
        block4: {
            if (!ModConfig.server.minecraft.lessCollisions) {
                return world.func_72839_b(entity, bb);
            }
            if (entity != null) {
                try {
                    return WorldRadiusUtil.instance.getEntitiesWithinAABBExcludingEntity(world, entity, bb, CollisionUtil.instance.getRadiusForEntity(entity));
                }
                catch (Exception e) {
                    if (warnItemHook) break block4;
                    warnItemHook = true;
                    RLTweaker.logger.error("Error running CollisionUtil!", (Throwable)e);
                    ErrorUtil.logSilent("CollisionUtil Critical Failure");
                }
            }
        }
        return world.func_72839_b(entity, bb);
    }

    public static List<Entity> getEntitiesInAABBexcluding(World world, @Nullable Entity entity, AxisAlignedBB bb, @Nullable Predicate<? super Entity> predicate) {
        block4: {
            if (!ModConfig.server.minecraft.lessCollisions) {
                return world.func_175674_a(entity, bb, predicate);
            }
            if (entity != null) {
                try {
                    return WorldRadiusUtil.instance.getEntitiesInAABBexcluding(world, entity, bb, predicate, CollisionUtil.instance.getRadiusForEntity(entity));
                }
                catch (Exception e) {
                    if (warnItemHook) break block4;
                    warnItemHook = true;
                    RLTweaker.logger.error("Error running CollisionUtil!", (Throwable)e);
                    ErrorUtil.logSilent("CollisionUtil Critical Failure");
                }
            }
        }
        return world.func_175674_a(entity, bb, predicate);
    }

    public static List<Entity> getEntitiesWithinAABB(World world, Class<Entity> clazz, AxisAlignedBB bb, @Nullable Predicate<? super Entity> predicate) {
        block3: {
            try {
                if (clazz.equals(EntityItem.class) || clazz.equals(EntityPlayer.class)) {
                    return WorldRadiusUtil.instance.getEntitiesWithinAABB(world, clazz, bb, predicate, 2.0);
                }
            }
            catch (Exception e) {
                if (warnSearchHook) break block3;
                warnSearchHook = true;
                RLTweaker.logger.error("Error running ReducedSearchSize!", (Throwable)e);
                ErrorUtil.logSilent("ReducedSearchSize Critical Failure");
            }
        }
        return world.func_175647_a(clazz, bb, predicate);
    }

    public static ChunkTickContainer onPreUpdateBlocks(WorldServer world) {
        if (!chunkTickPatchEnabled) {
            chunkTickPatchEnabled = true;
        }
        return new ChunkTickContainer(world);
    }

    public static void postBlockTickChunk(Chunk chunk, ChunkTickContainer container) {
        if (container.sereneSeasonsCompanionPost != null) {
            sereneSeasonsPost.invoke(chunk, container.sereneSeasonsCompanionPost);
        }
    }

    public static interface IChunkTickPost<T> {
        @Nullable
        public T preUpdate(WorldServer var1);

        public void invoke(Chunk var1, T var2);
    }

    public static class ChunkTickContainer {
        public Object sereneSeasonsCompanionPost;

        public ChunkTickContainer(WorldServer world) {
            this.sereneSeasonsCompanionPost = sereneSeasonsPost == null ? null : sereneSeasonsPost.preUpdate(world);
        }
    }
}

