/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.capability.ITweakerCapability;
import com.charles445.rltweaker.capability.RLCapabilities;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.TANReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class TANHandler {
    private TANReflect reflector;

    public TANHandler() {
        block5: {
            try {
                this.reflector = new TANReflect();
                if (ModConfig.server.toughasnails.fixExtraAttackBug) {
                    if (Loader.isModLoaded((String)"iseedragons")) {
                        RLTweaker.logger.info("Skipping Tough as Nails Fix Extra Attack Bug, as ISeeDragons is in the pack.");
                        RLTweaker.logger.info("Configure this option in ISeeDragons instead.");
                    } else {
                        CompatUtil.wrapSpecificHandler("TANAttackEntity", x$0 -> new TANAttackEntity((IEventListener)x$0), "toughasnails.handler.thirst.ThirstStatHandler", "onAttackEntity");
                    }
                }
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup TANHandler!", (Throwable)e);
                ErrorUtil.logSilent("TAN Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block5;
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public void onDismount(EntityMountEvent event) {
        if (event.isDismounting() && event.getEntityMounting() instanceof EntityPlayer && ModConfig.server.toughasnails.fixDismountThirstDrainBug) {
            ((EntityPlayer)event.getEntityMounting()).func_70637_d(false);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        if (!world.field_72995_K) {
            try {
                Object data = this.reflector.getThirstData(player);
                float currentExhaustion = this.reflector.readExhaustionFromData(data);
                ITweakerCapability tweakData = RLCapabilities.getTweakerData(player);
                if (ModConfig.server.toughasnails.fixTeleportThirst) {
                    float storedExhaustion = tweakData.getTANExhaustion();
                    float exhaustionChange = currentExhaustion - storedExhaustion;
                    if (event.phase == TickEvent.Phase.START) {
                        if (exhaustionChange > (float)ModConfig.server.toughasnails.teleportThirstThreshold) {
                            this.reflector.setExhaustionInData(data, storedExhaustion);
                        }
                    } else {
                        tweakData.setTANExhaustion(currentExhaustion);
                    }
                }
                if (event.phase == TickEvent.Phase.START && ModConfig.server.toughasnails.sendExtraThirstPackets) {
                    int tanPackets = tweakData.getThirstPacketTicks();
                    if (tanPackets >= ModConfig.server.toughasnails.extraThirstPacketFrequency) {
                        tweakData.setThirstPacketTicks(0);
                        SimpleNetworkWrapper packetHandler = this.reflector.getPacketHandlerInstance();
                        if (packetHandler != null && player instanceof EntityPlayerMP) {
                            packetHandler.sendTo(this.reflector.createUpdateMessageWithStat(data), (EntityPlayerMP)player);
                        }
                    } else {
                        tweakData.incrementThirstPacketTicks();
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                RLTweaker.logger.error("Error in onPlayerTick TANHandler Invoke", (Throwable)e);
                ErrorUtil.logSilent("TANHandler onPlayerTick");
                throw new RuntimeException(e);
            }
        }
    }

    public class TANAttackEntity {
        private IEventListener handler;

        public TANAttackEntity(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onAttackEntity(AttackEntityEvent event) {
            EntityPlayer player = event.getEntityPlayer();
            Entity monster = event.getTarget();
            if (monster == null || player == null) {
                return;
            }
            World world = monster.func_130014_f_();
            if (world == null || world.field_72995_K) {
                return;
            }
            if (monster.func_70075_an() && !player.func_184812_l_() && !monster.func_85031_j((Entity)player)) {
                try {
                    Object thirstHandler = TANHandler.this.reflector.getThirstData(player);
                    if (TANHandler.this.reflector.isThirstHandlerInstance(thirstHandler)) {
                        TANHandler.this.reflector.addExhaustion(thirstHandler, 0.3f);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    ErrorUtil.logSilent("TANHandler Extra Attack Invocation");
                }
            }
        }
    }
}

