/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.HashSet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class SpawnerControlHandler {
    public SpawnerControlHandler() {
        block4: {
            try {
                if (ModConfig.server.spawnercontrol.synchronizeSpawnerIteration || ModConfig.server.spawnercontrol.removeWorldTicks) {
                    CompatUtil.wrapSpecificHandler("SCWorldTick", x$0 -> new SCWorldTick((IEventListener)x$0), "ladysnake.spawnercontrol.SpawnerEventHandler", "onTickWorldTick");
                }
                if (ModConfig.server.spawnercontrol.removeWorldTicks) {
                    Class<?> c_SpawnerEventHandler = Class.forName("ladysnake.spawnercontrol.SpawnerEventHandler");
                    Field f_SpawnerEventHandler_allSpawners = ReflectUtil.findField(c_SpawnerEventHandler, "allSpawners");
                    f_SpawnerEventHandler_allSpawners.set(null, new DenySet());
                }
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup SpawnerControlHandler!", (Throwable)e);
                ErrorUtil.logSilent("Spawner Control Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public class SCWorldTick {
        private IEventListener handler;
        private boolean synchronizeSpawnerIteration;
        private boolean removeWorldTicks;

        public SCWorldTick(IEventListener handler) {
            this.synchronizeSpawnerIteration = ModConfig.server.spawnercontrol.synchronizeSpawnerIteration;
            this.removeWorldTicks = ModConfig.server.spawnercontrol.removeWorldTicks;
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onWorldTick(TickEvent.WorldTickEvent event) {
            if (this.removeWorldTicks) {
                return;
            }
            if (event.phase == TickEvent.Phase.START || event.side == Side.CLIENT) {
                return;
            }
            if (this.synchronizeSpawnerIteration) {
                SCWorldTick sCWorldTick = this;
                synchronized (sCWorldTick) {
                    this.handler.invoke((Event)event);
                }
            } else {
                this.handler.invoke((Event)event);
            }
        }
    }

    public class DenySet<T>
    extends HashSet<T> {
        @Override
        public boolean add(Object val) {
            return false;
        }
    }
}

