/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.RuinsReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RuinsHandler {
    private RuinsReflect reflector;

    public RuinsHandler() {
        block3: {
            try {
                this.reflector = new RuinsReflect();
                if (ModConfig.server.ruins.removeRUINSTRIGGERFunctionality) {
                    CompatUtil.findAndRemoveHandlerFromEventBus("atomicstryker.ruins.common.RuinsMod", "onEntityEnteringChunk");
                }
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup RuinsHandler!", (Throwable)e);
                ErrorUtil.logSilent("Ruins Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        block10: {
            World world = event.getWorld();
            if (world.field_72995_K) {
                return;
            }
            if (ModConfig.server.ruins.cleanupChunkLogger) {
                try {
                    ConcurrentHashMap<Integer, Object> generatorMap = this.reflector.getGeneratorMap();
                    int dimension = world.field_73011_w.getDimension();
                    generatorMap.remove(dimension);
                    WorldSavedData chunkLoggerData = world.getPerWorldStorage().func_75742_a(this.reflector.c_ChunkLoggerData, "ruinschunklogger");
                    if (chunkLoggerData == null) break block10;
                    WorldSavedData worldSavedData = chunkLoggerData;
                    synchronized (worldSavedData) {
                        try {
                            if (this.reflector.wipeChunkLoggerData(chunkLoggerData, ModConfig.server.ruins.chunkThreshold)) {
                                chunkLoggerData.func_76186_a(true);
                                RLTweaker.logger.info("Wiped ruinschunklogger.dat for dimension " + world.field_73011_w.getDimension());
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            RLTweaker.logger.error("onWorldLoad critical failure in RuinsHandler!", (Throwable)e);
                            ErrorUtil.logSilent("RuinsHandler Critical Failure");
                            throw new RuntimeException(e);
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    RLTweaker.logger.error("onWorldLoad critical failure in RuinsHandler!", (Throwable)e);
                    ErrorUtil.logSilent("RuinsHandler Critical Failure");
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

