/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.FBPClientReflect;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FBPHandlerClient {
    FBPClientReflect reflector;
    @Nullable
    FBPGhostListener listener;

    public FBPHandlerClient() {
        block3: {
            this.listener = null;
            try {
                this.reflector = new FBPClientReflect();
                if (ModConfig.client.fbp.fixPlacementGhostBlocks) {
                    this.listener = new FBPGhostListener();
                }
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup FBPHandlerClient!", (Throwable)e);
                ErrorUtil.logSilent("FBP Client Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public class FBPGhostListener
    implements IWorldEventListener {
        public FBPGhostListener() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void onWorldLoadEvent(WorldEvent.Load event) {
            event.getWorld().func_72954_a((IWorldEventListener)this);
        }

        public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
            if (newState.func_177230_c() == FBPHandlerClient.this.reflector.o_FBPBlock && oldState.func_177230_c() == Blocks.field_150350_a) {
                try {
                    Object blockNode = FBPHandlerClient.this.reflector.getBlockNode(pos);
                    if (blockNode != null) {
                        FBPHandlerClient.this.reflector.setBlockNodeToAir(blockNode);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    ErrorUtil.logSilent("FBP BlockNodeToAir Invocation");
                }
            }
        }

        public void func_174959_b(BlockPos pos) {
        }

        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        }

        public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        }

        public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
        }

        public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_72703_a(Entity entityIn) {
        }

        public void func_72709_b(Entity entityIn) {
        }

        public void func_180440_a(int soundID, BlockPos pos, int data) {
        }

        public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
        }

        public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        }
    }
}

