/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.asm.patch;

import com.charles445.rltweaker.asm.helper.ObfHelper;
import com.charles445.rltweaker.asm.patch.Patch;
import com.charles445.rltweaker.asm.patch.PatchManager;
import com.charles445.rltweaker.asm.util.TransformUtil;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PatchOverlayMessage
extends PatchManager {
    public PatchOverlayMessage() {
        super("Overlay Message");
        this.add(new Patch(this, "net.minecraftforge.client.GuiIngameForge", 1){

            @Override
            public void patch(ClassNode clazzNode) {
                MethodNode m_renderGameOverlay = this.findMethod(clazzNode, "renderRecordOverlay");
                if (m_renderGameOverlay == null) {
                    throw new RuntimeException("Couldn't find renderRecordOverlay");
                }
                IntInsnNode anchor = TransformUtil.findNextIntInsnNodeWithValue(this.first(m_renderGameOverlay), 68);
                if (anchor == null) {
                    throw new RuntimeException("Couldn't find BIPUSH 68 in renderRecordOverlay");
                }
                this.insert(m_renderGameOverlay, (AbstractInsnNode)anchor, (AbstractInsnNode)new MethodInsnNode(184, "com/charles445/rltweaker/hook/HookMinecraft", "overlayTextYOffset", "(I)I", false));
                MethodInsnNode textCall = TransformUtil.findNextCallWithOpcodeAndName((AbstractInsnNode)anchor, 182, "func_78276_b", "drawString");
                if (textCall == null) {
                    throw new RuntimeException("Couldn't find func_78276_b or drawString call in renderRecordOverlay");
                }
                textCall.name = ObfHelper.isObfuscated() ? "func_175065_a" : "drawString";
                textCall.desc = "(Ljava/lang/String;FFIZ)I";
                this.insertBefore(m_renderGameOverlay, (AbstractInsnNode)textCall, (AbstractInsnNode)new MethodInsnNode(184, "com/charles445/rltweaker/hook/HookMinecraft", "overlayTextDropShadow", "()Z", false));
                anchor = TransformUtil.findPreviousIntInsnNodeWithValue((AbstractInsnNode)textCall, -4);
                if (anchor == null) {
                    throw new RuntimeException("Couldn't find BIPUSH -4 in renderRecordOverlay, please report to RLTweaker dev");
                }
                this.insertInsnBefore(m_renderGameOverlay, (AbstractInsnNode)anchor, 134);
                this.insertInsn(m_renderGameOverlay, (AbstractInsnNode)anchor, 134);
            }
        });
    }
}

