/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.blocks;

import com.alcatrazescapee.alcatrazcore.block.BlockCore;
import com.alcatrazescapee.notreepunching.common.blocks.ModBlocks;
import com.alcatrazescapee.notreepunching.common.items.ModItems;
import com.alcatrazescapee.notreepunching.util.types.Pottery;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockPottery
extends BlockCore {
    private static final Map<Pottery, BlockPottery> MAP = new HashMap<Pottery, BlockPottery>();
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.875, 0.875), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.625, 0.75), new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.625, 0.6875), new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875)};
    private final Pottery type;

    public static BlockPottery get(Pottery type) {
        return MAP.get((Object)type);
    }

    public BlockPottery(Pottery type) {
        super(Material.field_151571_B);
        this.type = type;
        MAP.put(type, this);
        this.func_149711_c(0.8f - 0.1f * (float)type.ordinal());
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(SoundType.field_185849_b);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        if (this.type == Pottery.LARGE_VESSEL) {
            super.registerModel();
        } else if (this.type != Pottery.WORKED) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    @Nonnull
    public Pottery getType() {
        return this.type;
    }

    @Nonnull
    public ItemStack getFiredType() {
        switch (this.type) {
            case LARGE_VESSEL: {
                return new ItemStack(ModBlocks.CERAMIC_LARGE_VESSEL);
            }
            case BUCKET: {
                return new ItemStack(ModItems.CERAMIC_BUCKET);
            }
            case SMALL_VESSEL: {
                return new ItemStack(ModItems.CERAMIC_SMALL_VESSEL);
            }
            case FLOWER_POT: {
                return new ItemStack(Items.field_151162_bE);
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[this.type.ordinal()];
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB[this.type.ordinal()];
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.type == Pottery.WORKED) {
            drops.clear();
            drops.add((Object)new ItemStack(Items.field_151119_aD, 3));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.type == Pottery.WORKED) {
            return new ItemStack(Blocks.field_150435_aG);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }
}

