/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.blocks;

import com.alcatrazescapee.alcatrazcore.block.BlockTileCore;
import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.alcatrazcore.util.compat.FireRegistry;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.NoTreePunching;
import com.alcatrazescapee.notreepunching.client.particle.ParticleManager;
import com.alcatrazescapee.notreepunching.common.tile.TileFirePit;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockFirePit
extends BlockTileCore {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockFirePit() {
        super(Material.field_151594_q);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185848_a);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{LIT}).func_178441_a());
        super.registerModel();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileFirePit();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.375, 0.0, 0.375, 0.615, 0.0625, 0.625);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (!worldIn.field_72995_K && worldIn.func_175710_j(pos) && worldIn.func_72896_J() && worldIn.func_175672_r(pos).func_177956_o() < pos.func_177956_o() + 2) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            ParticleManager.generateFirePitFlame(worldIn, pos);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            if (worldIn.func_175710_j(pos) && worldIn.func_72896_J() && worldIn.func_175672_r(pos).func_177956_o() < pos.func_177956_o() + 2 && rand.nextFloat() < 0.5f) {
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                ParticleManager.generateFirePitSmoke(worldIn, pos);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileFirePit te = (TileFirePit)CoreHelpers.getTE((IBlockAccess)world, (BlockPos)pos, TileFirePit.class);
        if (te != null) {
            ItemStack stack = player.func_184586_b(hand);
            if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                if (CoreHelpers.doesStackMatchOre((ItemStack)stack, (String)"sand")) {
                    te.extinguish();
                    if (!world.field_72995_K) {
                        player.func_184611_a(hand, CoreHelpers.consumeItem((EntityPlayer)player, (ItemStack)stack, (int)1));
                    }
                    return true;
                }
                if (CoreHelpers.doesStackMatchOre((ItemStack)stack, (String)"stickWood")) {
                    if (!world.field_72995_K && ModConfig.GENERAL.allowTorchesFromFirePits) {
                        CoreHelpers.giveItemToPlayer((World)world, (EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150478_aa, 2));
                        player.func_184611_a(hand, CoreHelpers.consumeItem((EntityPlayer)player, (ItemStack)stack, (int)1));
                        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 1.5f);
                    }
                    return true;
                }
            } else if (FireRegistry.isFireStarter((ItemStack)stack)) {
                te.light(false);
                if (!world.field_72995_K) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                return true;
            }
            if (!player.func_70093_af() && !world.field_72995_K) {
                player.openGui((Object)NoTreePunching.getInstance(), 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)LIT);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
        drops.add((Object)new ItemStack(Items.field_151055_y, 2, 0));
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState stateUnder;
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.field_72995_K && !(stateUnder = worldIn.func_180495_p(pos.func_177977_b())).func_185915_l()) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }
}

